<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\RoiSchedule;
use Carbon\Carbon;

class UpdateRoiStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'roi:update-status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update ROI status - mark pending ROI as ready when timer expires';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Updating ROI status...');
        
        // Find all pending ROI schedules where timer has expired
        $expiredSchedules = RoiSchedule::where('status', 'pending')
            ->where('roi_end_time', '<=', now())
            ->get();
            
        $updatedCount = 0;
        
        foreach ($expiredSchedules as $schedule) {
            $schedule->markAsReady();
            $updatedCount++;
            
            $this->line("ROI marked as ready for User ID: {$schedule->user_id}, Investment ID: {$schedule->invest_id}, Cycle: {$schedule->roi_cycle}");
        }
        
        $this->info("Updated {$updatedCount} ROI schedules to ready status.");
        
        return Command::SUCCESS;
    }
}
