<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use JoeDixon\Translation\Console\Commands\SynchroniseMissingTranslationKeys;
use App\Console\Commands\DistributeRankingSalary;
use App\Console\Commands\AddDailyProfit;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array<int, class-string|string>
     */
    protected $commands = [
        SynchroniseMissingTranslationKeys::class,
        DistributeRankingSalary::class,
        AddDailyProfit::class,
        \App\Console\Commands\TestScheduler::class,
        \App\Console\Commands\ResetDashboard::class,
        \App\Console\Commands\GenerateUserAvatars::class,
        \App\Console\Commands\AutoApproveManualDeposits::class,
        \App\Console\Commands\AutoRoiDistribution::class,
        \App\Console\Commands\AutoAchievementDistribution::class,
        \App\Console\Commands\UpdateRoiStatus::class,
        \App\Console\Commands\CreateExistingRoiSchedules::class,
        \App\Console\Commands\UpdateRoiSchedulePeriods::class,
        \App\Console\Commands\SetUserRoiTimer::class,
        \App\Console\Commands\FixRoiSchedulesLogic::class,
        \App\Console\Commands\CheckRoiStatus::class,
        \App\Console\Commands\UpdateRoiStatus::class,
        \App\Console\Commands\FixRoiStatus::class,
        \App\Console\Commands\AutoRoiCollection::class,
        \App\Console\Commands\CheckRoiPeriods::class,
        \App\Console\Commands\CheckRoiCycles::class,
        \App\Console\Commands\TestSchemaChange::class,
        \App\Console\Commands\SetTestRoiPeriod::class,
        \App\Console\Commands\TestRoiCollection::class,
        \App\Console\Commands\FixTestRoiPeriod::class,
        \App\Console\Commands\TestProfitBalance::class,
        \App\Console\Commands\TestInvestmentCancel::class,
    ];

    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('test:scheduler')->everyMinute()->appendOutputTo(storage_path('logs/test-scheduler.log'));

        // Run salary distribution on 1st day of every month at midnight
        $schedule->command('salary:distribute')->monthlyOn(1, '00:00');

        // Run daily profit distribution at 8:00 PM Pakistani time
        $schedule->command('invest:add-daily-profit')
            ->dailyAt('20:00')
            ->timezone('Asia/Karachi')
            ->withoutOverlapping()
            ->runInBackground()
            ->appendOutputTo(storage_path('logs/profit-distribution.log'));

        // Auto approve manual deposits every 30 minutes
        $schedule->command('deposit:auto-approve-manual')
            ->everyThirtyMinutes()
            ->timezone('Asia/Karachi')
            ->withoutOverlapping()
            ->runInBackground()
            ->appendOutputTo(storage_path('logs/deposit-approval.log'));

        // Auto ROI distribution every hour
        $schedule->command('roi:auto-distribute')
            ->hourly()
            ->timezone('Asia/Karachi')
            ->withoutOverlapping()
            ->runInBackground()
            ->appendOutputTo(storage_path('logs/roi-distribution.log'));

        // Auto achievement distribution daily at 9:00 PM
        $schedule->command('achievement:auto-distribute')
            ->dailyAt('21:00')
            ->timezone('Asia/Karachi')
            ->withoutOverlapping()
            ->runInBackground()
            ->appendOutputTo(storage_path('logs/achievement-distribution.log'));

        // Update ROI status every minute
        $schedule->command('roi:update-status')
            ->everyMinute()
            ->timezone('Asia/Karachi')
            ->withoutOverlapping()
            ->runInBackground()
            ->appendOutputTo(storage_path('logs/roi-status-update.log'));

        // Auto ROI collection every 5 minutes
        $schedule->command('roi:auto-collect')
            ->everyFiveMinutes()
            ->timezone('Asia/Karachi')
            ->withoutOverlapping()
            ->runInBackground()
            ->appendOutputTo(storage_path('logs/roi-auto-collection.log'));
    }
}
