<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Investment;
use Carbon\Carbon;

class ProcessMonthlySalaries extends Command
{
    protected $signature = 'salary:process';
    protected $description = 'Add monthly salary to users\' profit wallet';

    public function handle()
    {
        $now = Carbon::now();

        $investments = Investment::where('next_salary_date', '<=', $now)->get();

        foreach ($investments as $investment) {
            $user = $investment->user;
            $salary = $investment->plan->salary_amount; // ya schema, jo bhi naam hai

            $user->profit_wallet += $salary;
            $user->save();

            $investment->next_salary_date = $now->addMonth();
            $investment->save();

            $this->info("Salary added for user: {$user->id}");
        }
    }
}
