<?php

namespace App\Enums;

enum TxnType: string
{
    case Deposit = 'deposit';
    case Subtract = 'subtract';
    case ManualDeposit = 'manual_deposit';
    case SendMoney = 'send_money';
    case Exchange = 'exchange';
    case Referral = 'referral';
    case SignupBonus = 'signup_bonus';
    case Bonus = 'bonus';
    case Withdraw = 'withdraw';
    case WithdrawAuto = 'withdraw_auto';
    case ReceiveMoney = 'receive_money';
     case Salary = 'salary'; 
    case Investment = 'investment';
    case Interest = 'interest';
    case Refund = 'refund';
    case Transfer = 'transfer';
    case Commission = 'commission';
    case Charge = 'charge';
    case Profit = 'profit';
    case CapitalReturn = 'capital_return';

    public function badge(): string
    {
        return match($this) {
            self::Deposit => 'success',
            self::Subtract => 'danger',
            self::ManualDeposit => 'success',
            self::SendMoney => 'warning',
            self::Exchange => 'primary',
            self::Referral => 'success',
            self::SignupBonus => 'success',
            self::Bonus => 'success',
            self::Withdraw => 'warning',
            self::WithdrawAuto => 'warning',
            self::ReceiveMoney => 'info',
            self::Investment => 'info',
            self::Interest => 'success',
            self::Refund => 'secondary',
            self::Transfer => 'info',
            self::Commission => 'success',
            self::Charge => 'danger',
            self::Profit => 'success',
            self::CapitalReturn => 'primary',
        };
    }
}
