<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Theme;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ThemeController extends Controller
{
    public function index()
    {
        $themes = Theme::where('type', 'site')->get();
        return view('admin.theme.index', compact('themes'));
    }

    public function activate(Request $request)
    {
        $request->validate([
            'theme_id' => 'required|exists:themes,id'
        ]);

        try {
            DB::beginTransaction();

            // Deactivate all themes
            Theme::where('type', 'site')->update(['status' => false]);

            // Activate selected theme
            $theme = Theme::findOrFail($request->theme_id);
            $theme->update(['status' => true]);

            DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'Theme activated successfully!'
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => 'Failed to activate theme: ' . $e->getMessage()
            ], 500);
        }
    }

    public function preview($id)
    {
        $theme = Theme::findOrFail($id);
        
        // Store current theme
        $currentTheme = Theme::where('type', 'site')->where('status', true)->first();
        
        // Temporarily activate preview theme
        Theme::where('type', 'site')->update(['status' => false]);
        $theme->update(['status' => true]);
        
        // Redirect to home page for preview
        return redirect()->route('home');
    }
}