<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function dashboard(Request $request)
    {

        $user = auth()->user();
        //   dd($user->profit_balance);
        $transactions = Transaction::where('user_id', $user->id);

        $recentTransactions = $transactions->latest()->take(5)->get();

        $referral = $user->getReferrals()->first();


        $dataCount = [
            'total_transaction' => $transactions->count(),
            'total_deposit' => $user->totalDeposit(),
            'total_investment' => $user->totalInvestment(),
            'salary' => Transaction::where('user_id', $user->id)
                ->where('type', 'salary')
                ->sum('amount'),
            'total_profit' => $user->totalProfit(),
            'profit_last_7_days' => $user->totalProfit(7),
            'total_withdraw' => $user->totalWithdraw(),
            'total_transfer' => $user->totalTransfer(),
            'total_referral_profit' => $user->totalReferralProfit(),
            // ✅ FIXED: Use proper referral count method
            'total_referral' => $user->getTotalReferralCount(),
            // ✅ ADDED: Referral count by date ranges
            'referral_7_days' => $user->getReferralCountByDate(7),
            'referral_30_days' => $user->getReferralCountByDate(30),
            'referral_earnings_7_days' => $user->getReferralEarnings(7),
            'referral_earnings_30_days' => $user->getReferralEarnings(30),
            // ✅ ADDED: Referral investment data
            'total_referral_investments' => $user->getTotalReferralInvestments(),
            'total_referral_deposits' => $user->getTotalReferralDeposits(),
            'total_referral_profits' => $user->getTotalReferralProfits(),
            'referral_investment_summary' => $user->getReferralInvestmentSummary(),
            // Network Bonus = investment_bonus + referral_bonus + salary
            'network_bonus' => $user->profit_balance,
            // ✅ ADDED: Support tickets count
            'total_ticket' => \App\Models\Ticket::where('user_id', $user->id)->count(),


            'deposit_bonus' => $user->totalDepositBonus(),
            // 'investment_bonus' => $user->totalInvestBonus(),
            'rank_achieved' => $user->rankAchieved(),
        ];

        $referral = $user->getReferrals()->first();
        
        // Get user investments for dashboard
        $investments = \App\Models\Invest::where('user_id', $user->id)
            ->with(['schema', 'roiSchedules', 'activeRoiSchedule', 'readyRoiSchedule'])
            ->latest()
            ->take(5)
            ->get();
            
        $totalInvested = $investments->sum('invest_amount');
        $totalProfit = $investments->sum('total_profit_amount');
        $activeInvestments = $investments->where('status', 'ongoing')->count();
        $completedInvestments = $investments->where('status', 'completed')->count();
        
        return view('frontend.shahdeveloper.user.dashboard', compact('dataCount', 'recentTransactions', 'referral', 'investments', 'totalInvested', 'totalProfit', 'activeInvestments', 'completedInvestments'));
    }

    /**
     * Calculate ROI progress percentage for an investment
     */
    private function calculateRoiProgress($investment)
    {
        if ($investment->status !== 'ongoing') {
            return 100; // Completed investments show 100%
        }

        $now = \Carbon\Carbon::now();
        $nextProfitTime = \Carbon\Carbon::parse($investment->next_profit_time);
        
        // If ROI is ready (next profit time has passed)
        if ($nextProfitTime <= $now) {
            return 100;
        }

        // Get the last profit time or investment creation time
        $lastProfitTime = $investment->last_profit_time ? 
            \Carbon\Carbon::parse($investment->last_profit_time) : 
            \Carbon\Carbon::parse($investment->created_at);

        // Calculate total time between last profit and next profit
        $totalTime = $lastProfitTime->diffInMinutes($nextProfitTime);
        $elapsedTime = $lastProfitTime->diffInMinutes($now);

        if ($totalTime <= 0) {
            return 100;
        }

        $progress = ($elapsedTime / $totalTime) * 100;
        return min(100, max(0, round($progress, 1)));
    }
}
