<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Schema;

class SchemaController extends Controller
{
    public function index()
    {
        $schemas = Schema::where('status', true)->ordered()->with('schedule')->get();
        
        $data = [
            'title' => 'Investment Plans',
            'meta_keywords' => 'investment, plans, schemes, trading',
            'meta_description' => 'Choose from our investment plans and start earning today'
        ];

        return view('frontend::pages.schema', compact('schemas', 'data'));
    }

    public function schemaPreview($id)
    {

        $schemas = Schema::where('status', true)->ordered()->with('schedule')->get();
        $schema = Schema::with('schedule')->find($id);

        return view('frontend::pages.schema', compact('schema', 'schemas'));
    }

    public function schemaSelect($id)
    {
        $schema = Schema::with('schedule')->find($id);
        
        if (!$schema) {
            notify()->error('Plan not found', 'Error');
            return redirect()->route('user.schema');
        }

        return view('frontend::user.invest', compact('schema'));
    }
}
