<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Carbon\Carbon;
use Illuminate\Http\Request;

class TransactionController extends Controller
{
    public function transactions()
    {
        $transactions = Transaction::search(request('query'), function ($query) {
                                $query->where('user_id', auth()->user()->id)
                                    ->when(request('date'), function ($query) {
                                        $query->whereDate('created_at',Carbon::parse(request('date')));
                                    })
                                    ->when(request('type'), function ($query) {
                                        $query->where('type',request('type'));
                                    });
                            })->where('user_id', auth()->user()->id)
                            ->orderBy('created_at', 'desc')
                            ->paginate(10)
                            ->withQueryString();

        // Check if shahdeveloper theme is active
        if (setting('active_theme', 'theme') === 'shahdeveloper') {
            return view('frontend.shahdeveloper.user.transaction.index', compact('transactions'));
        }
        
        return view('frontend::user.transaction.index', compact('transactions'));
    }

    public function latest(Request $request)
    {
        $user = auth()->user();
        if (!$user) {
            return response()->json(['items' => []]);
        }

        $limit = (int) ($request->query('limit', 10));
        $limit = $limit > 0 && $limit <= 50 ? $limit : 10;

        $transactions = Transaction::where('user_id', $user->id)
            ->orderByDesc('created_at')
            ->limit($limit)
            ->get(['id','tnx','type','status','amount','final_amount','currency','created_at']);

        $items = $transactions->map(function($t){
            return [
                'id' => $t->id,
                'tnx' => $t->tnx,
                'type' => $t->type,
                'status' => $t->status,
                'amount' => (float) $t->amount,
                'final_amount' => (float) $t->final_amount,
                'currency' => $t->currency,
                'created_at' => $t->getRawOriginal('created_at'),
                'created_at_iso' => Carbon::parse($t->getRawOriginal('created_at'))->toIso8601String(),
                'created_at_human' => Carbon::parse($t->getRawOriginal('created_at'))->diffForHumans(),
            ];
        });

        return response()->json(['items' => $items]);
    }
}
