<?php

namespace App\Http\Controllers\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserTransfer;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserTransferController extends Controller
{
    public function showTransferForm()
    {
       return view('user.transfer');
    }

 public function transfer(Request $request)
{
   $request->validate([
    'receiver_identifier' => 'required|email|exists:users,email',
    'amount' => 'required|numeric|min:0.01',
]);

    $sender = auth()->user();
$receiver = User::where('email', $request->receiver_identifier)->first();
    $amount = $request->amount;

    // Prevent self-transfer
    if ($sender->id === $receiver->id) {
        return back()->with('error', 'You cannot send money to yourself.');
    }

    // Check if sender has enough balance
    if ($sender->balance < $amount) {
        return back()->with('error', 'Insufficient balance.');
    }

    // Perform transfer
    $sender->balance -= $amount;
    $sender->save();

    $receiver->balance += $amount;
    $receiver->save();

    return back()->with('success', 'Amount transferred successfully!');
}

}