<?php

namespace App\Http\Middleware;

use App\Enums\KYCStatus;
use Closure;
use Illuminate\Http\Request;

class KYCWithdraw
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse) $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if user is authenticated
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        // Check global withdraw permission
        if (!setting('user_withdraw', 'permission')) {
            notify()->error(__('Withdraw is currently disabled by admin.'), 'Withdraw Disabled');
            return redirect()->back();
        }

        // Check user's withdraw status
        if (!auth()->user()->withdraw_status) {
            notify()->error(__('Your withdraw has been disabled by admin. Please contact support for assistance.'), 'Withdraw Disabled');
            return redirect()->route('user.ticket.new');
        }

        // Check if KYC verification is enabled in settings
        if (!setting('kyc_verification', 'permission')) {
            return $next($request);
        }

        // Check if user's KYC is verified
        if (auth()->user()->kyc != KYCStatus::Verified->value) {
            notify()->error(__('KYC verification is required to withdraw funds. Please complete your KYC verification first.'), 'KYC Required');
            return redirect()->route('user.kyc');
        }

        return $next($request);
    }
}
