<?php

namespace App\Http\Middleware;

use App\Models\ReferralLink;
use Closure;
use Illuminate\Http\Request;

class StoreReferralCode
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse) $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);
        if (null == $request->cookie('invite') && $request->has('invite')) {
            // ✅ ADD DEBUG LOGGING
            \Log::info('🔍 StoreReferralCode Middleware Processing', [
                'invite_param' => $request->get('invite'),
                'has_cookie' => $request->hasCookie('invite'),
                'cookie_value' => $request->cookie('invite'),
            ]);
            
            $referral = ReferralLink::whereCode($request->get('invite'))->first();
            if (!$referral) {
                \Log::warning('⚠️ Referral link not found', ['code' => $request->get('invite')]);
                return $response;
            }
            
            \Log::info('🔍 Referral link found', [
                'code' => $referral->code,
                'id' => $referral->id,
                'user_id' => $referral->user_id,
                'storing_code' => $referral->code,
            ]);
            
            // ✅ FIXED: Store referral code instead of referral ID
            $response->withCookie(cookie('invite', $referral->code, $referral->lifetime_minutes));

            return $response;
        }

        return $response;
    }
}
