<?php

namespace App\Listeners;

use App\Enums\TxnStatus;
use App\Enums\TxnType;
use App\Events\UserReferred;
use App\Models\ReferralLink;
use App\Models\ReferralRelationship;
use App\Models\User;
use Txn;

class RewardUser
{
    public function __construct()
    {
        //
    }

    public function handle(UserReferred $event)
    {
        $referral = ReferralLink::find($event->referralId);

        if ($referral && $referral->user) {
            ReferralRelationship::create([
                'referral_link_id' => $referral->id,
                'user_id' => $event->user->id
            ]);

            $user = User::find($event->user->id);
            if ($user) {
                $user->update([
                    'ref_id' => $referral->user->id
                ]);
            }

            if (setting('sign_up_referral', 'permission') && $event->user->email_verified_at) {
                $referralBonus = (float)setting('referral_bonus', 'fee');
                $provider = $referral->user;

                $provider->increment('profit_balance', $referralBonus);

                Txn::new(
                    $referralBonus,
                    0,
                    $referralBonus,
                    'system',
                    'Referral Bonus via ' . $event->user->full_name,
                    TxnType::Referral,
                    TxnStatus::Success,
                    null,
                    null,
                    $provider->id
                );
            }
        }
    }
}