<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReferralContribution extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'referral_id',
        'amount',
    ];

    /**
     * Get the user that owns the contribution.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the referral user.
     */
    public function referral()
    {
        return $this->belongsTo(User::class, 'referral_id');
    }
}
