<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWallet extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'wallet_type',
        'wallet_name',
        'wallet_icon',
        'balance',
        'currency',
        'exchange_rate',
        'is_active'
    ];

    protected $casts = [
        'balance' => 'decimal:8',
        'exchange_rate' => 'decimal:8',
        'is_active' => 'boolean'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getFormattedBalanceAttribute()
    {
        return number_format($this->balance, 2);
    }

    public function getUsdValueAttribute()
    {
        return $this->balance * $this->exchange_rate;
    }

    public function canWithdraw($amount)
    {
        return $this->balance >= $amount;
    }

    public function addBalance($amount)
    {
        $this->balance += $amount;
        $this->save();
    }

    public function deductBalance($amount)
    {
        if ($this->canWithdraw($amount)) {
            $this->balance -= $amount;
            $this->save();
            return true;
        }
        return false;
    }
}