<?php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Checking transaction with proof_file containing YZ8p2LKSS2GNEQRC6J2Q...\n";

$transaction = App\Models\Transaction::where('proof_file', 'like', '%YZ8p2LKSS2GNEQRC6J2Q%')->first();

if($transaction) {
    echo "Found transaction:\n";
    echo "ID: " . $transaction->id . "\n";
    echo "Proof File: " . $transaction->proof_file . "\n";
    echo "Status: " . $transaction->status->value . "\n";
    echo "Created: " . $transaction->created_at . "\n";
} else {
    echo "Transaction not found\n";
    
    // Let's check all transactions with proof files
    echo "\nChecking all transactions with proof files...\n";
    $transactions = App\Models\Transaction::whereNotNull('proof_file')->get();
    
    foreach($transactions as $txn) {
        echo "ID: {$txn->id}, Proof: {$txn->proof_file}\n";
    }
}
