<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('roi_distributions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('investment_id')->constrained('invests')->onDelete('cascade');
            $table->decimal('roi_amount', 15, 2);
            $table->enum('distribution_type', ['manual', 'bulk', 'auto'])->default('manual');
            $table->foreignId('distributed_by')->constrained('admins')->onDelete('cascade');
            $table->timestamp('distribution_time');
            $table->text('notes')->nullable();
            $table->boolean('is_reversed')->default(false);
            $table->timestamp('reversed_at')->nullable();
            $table->foreignId('reversed_by')->nullable()->constrained('admins')->onDelete('set null');
            $table->text('reversal_reason')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'distribution_time']);
            $table->index(['investment_id', 'distribution_time']);
            $table->index(['distributed_by', 'distribution_time']);
            $table->index(['is_reversed', 'distribution_time']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('roi_distributions');
    }
};
