<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_wallets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('wallet_type'); // USD, BTC, ETH, SOL, etc.
            $table->string('wallet_name'); // Bitcoin Wallet, Ethereum Wallet, etc.
            $table->string('wallet_icon')->default('💰');
            $table->decimal('balance', 20, 8)->default(0);
            $table->string('currency', 10)->default('USD');
            $table->decimal('exchange_rate', 20, 8)->default(1);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->unique(['user_id', 'wallet_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_wallets');
    }
};




