<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('schemas', function (Blueprint $table) {
            $table->decimal('early_withdrawal_deduction', 5, 2)->default(25)->after('schema_duration');
            $table->integer('money_back_period')->default(15)->after('early_withdrawal_deduction');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('schemas', function (Blueprint $table) {
            $table->dropColumn(['early_withdrawal_deduction', 'money_back_period']);
        });
    }
};
