<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('transactions', 'proof_file')) {
                $table->string('proof_file')->nullable()->after('pay_amount');
            }
            if (!Schema::hasColumn('transactions', 'transaction_hash')) {
                $table->string('transaction_hash')->nullable()->after('proof_file');
            }
            if (!Schema::hasColumn('transactions', 'notes')) {
                $table->text('notes')->nullable()->after('transaction_hash');
            }
            // optional status pending_proof already covered by status column; leave as is
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (Schema::hasColumn('transactions', 'notes')) {
                $table->dropColumn('notes');
            }
            if (Schema::hasColumn('transactions', 'transaction_hash')) {
                $table->dropColumn('transaction_hash');
            }
            if (Schema::hasColumn('transactions', 'proof_file')) {
                $table->dropColumn('proof_file');
            }
        });
    }
};
