<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Use raw SQL to drop indexes safely
        DB::statement('ALTER TABLE rankings DROP INDEX IF EXISTS rankings_ranking_unique');
        DB::statement('ALTER TABLE rankings DROP INDEX IF EXISTS rankings_ranking_name_unique');
        DB::statement('ALTER TABLE rankings DROP INDEX IF EXISTS rankings_minimum_earnings_unique');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('rankings', function (Blueprint $table) {
            // Re-add unique constraints if needed
            $table->unique('ranking');
            $table->unique('ranking_name');
            $table->unique('minimum_earnings');
        });
    }
};