<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roi_schedules', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invest_id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('schema_id');
            $table->decimal('invest_amount', 15, 2);
            $table->decimal('roi_percentage', 5, 2);
            $table->decimal('roi_amount', 15, 2);
            $table->timestamp('roi_start_time');
            $table->timestamp('roi_end_time');
            $table->timestamp('roi_ready_time')->nullable();
            $table->timestamp('roi_sent_time')->nullable();
            $table->enum('status', ['pending', 'ready', 'sent', 'completed'])->default('pending');
            $table->integer('roi_cycle')->default(1); // Which ROI cycle this is (1st, 2nd, 3rd, etc.)
            $table->integer('total_cycles'); // Total cycles for this plan
            $table->timestamps();
            
            $table->foreign('invest_id')->references('id')->on('invests')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('schema_id')->references('id')->on('schemas')->onDelete('cascade');
            
            $table->index(['user_id', 'status']);
            $table->index(['schema_id', 'status']);
            $table->index('roi_ready_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roi_schedules');
    }
};
