<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invests', function (Blueprint $table) {
            $table->boolean('is_cancelled')->default(false)->after('status');
            $table->timestamp('cancelled_at')->nullable()->after('is_cancelled');
            $table->text('cancellation_reason')->nullable()->after('cancelled_at');
            $table->decimal('cancellation_deduction', 10, 2)->default(0)->after('cancellation_reason');
            $table->decimal('refund_amount', 10, 2)->default(0)->after('cancellation_deduction');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invests', function (Blueprint $table) {
            $table->dropColumn([
                'is_cancelled',
                'cancelled_at', 
                'cancellation_reason',
                'cancellation_deduction',
                'refund_amount'
            ]);
        });
    }
};
