<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CheckReferralLinksTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        echo "🔍 Checking referral_links table structure...\n";
        
        try {
            // Check table structure
            $columns = DB::select('DESCRIBE referral_links');
            echo "📊 Table columns:\n";
            foreach ($columns as $column) {
                echo "  - {$column->Field}: {$column->Type} " . ($column->Null === 'YES' ? 'NULL' : 'NOT NULL') . "\n";
            }
            
            // Check if code column exists
            $codeExists = false;
            foreach ($columns as $column) {
                if ($column->Field === 'code') {
                    $codeExists = true;
                    break;
                }
            }
            
            if ($codeExists) {
                echo "\n✅ code column exists in referral_links table\n";
            } else {
                echo "\n❌ code column NOT found in referral_links table\n";
                echo "💡 This is why referral system is not working!\n";
            }
            
            // Check current data
            echo "\n📊 Current referral_links data:\n";
            $referralLinks = DB::table('referral_links')->get();
            foreach ($referralLinks as $link) {
                echo "  - ID: {$link->id}, User ID: {$link->user_id}, Code: " . ($link->code ?? 'NULL') . "\n";
            }
            
        } catch (\Exception $e) {
            echo "❌ Error: " . $e->getMessage() . "\n";
        }
    }
}

