<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Schedule;

class DefaultSchedulesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $schedules = [
            ['name' => 'Every 5 Minutes', 'time' => 5, 'status' => true],
            ['name' => 'Every 15 Minutes', 'time' => 15, 'status' => true],
            ['name' => 'Every 30 Minutes', 'time' => 30, 'status' => true],
            ['name' => 'Every 1 Hour', 'time' => 60, 'status' => true],
            ['name' => 'Every 6 Hours', 'time' => 360, 'status' => true],
            ['name' => 'Every 12 Hours', 'time' => 720, 'status' => true],
            ['name' => 'Every 24 Hours', 'time' => 1440, 'status' => true],
            ['name' => 'Every 2 Days', 'time' => 2880, 'status' => true],
            ['name' => 'Every 3 Days', 'time' => 4320, 'status' => true],
            ['name' => 'Every 7 Days', 'time' => 10080, 'status' => true],
        ];

        foreach ($schedules as $schedule) {
            Schedule::updateOrCreate(
                ['name' => $schedule['name']],
                $schedule
            );
        }

        $this->command->info('Default schedules seeded successfully!');
    }
}
