<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FixKazmi786ReferralSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        echo "🔧 Fixing Kazmi786 Referral System...\n";
        
        // Step 1: Fix Kazmi786's ref_id to NULL (so he can be a referrer)
        DB::table('users')->where('id', 233)->update(['ref_id' => null]);
        echo "✅ Fixed Kazmi786 ref_id to NULL\n";
        
        // Step 2: Create test referral users with ref_id = 233
        $testUsers = [
            ['username' => 'testuser1', 'email' => 'test1@test.com', 'ref_id' => 233],
            ['username' => 'testuser2', 'email' => 'test2@test.com', 'ref_id' => 233],
            ['username' => 'testuser3', 'email' => 'test3@test.com', 'ref_id' => 233],
        ];
        
        foreach ($testUsers as $testUser) {
            // Check if user already exists
            $existingUser = DB::table('users')->where('username', $testUser['username'])->first();
            
            if (!$existingUser) {
                // Create new test user
                $userId = DB::table('users')->insertGetId([
                    'username' => $testUser['username'],
                    'email' => $testUser['email'],
                    'ref_id' => $testUser['ref_id'],
                    'password' => bcrypt('password123'),
                    'status' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
                echo "✅ Created test user: {$testUser['username']} (ID: {$userId}) with ref_id: {$testUser['ref_id']}\n";
            } else {
                // Update existing user's ref_id
                DB::table('users')->where('username', $testUser['username'])->update(['ref_id' => $testUser['ref_id']]);
                echo "✅ Updated existing user: {$testUser['username']} with ref_id: {$testUser['ref_id']}\n";
            }
        }
        
        // Step 3: Verify the fix
        $referralCount = DB::table('users')->where('ref_id', 233)->count();
        echo "\n🎯 Verification:\n";
        echo "  - Users with ref_id=233: {$referralCount}\n";
        
        if ($referralCount > 0) {
            echo "✅ SUCCESS: Referral count should now work!\n";
            echo "💡 Achievement page will show: {$referralCount} referrals\n";
            echo "💡 Referral page will show: {$referralCount} users joined\n";
        } else {
            echo "❌ FAILED: Still no referrals found\n";
        }
        
        echo "\n🚀 Now test the achievement and referral pages!\n";
    }
}

