<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FixReferralCountSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        echo "🔍 Checking Referral System Status...\n";
        
        // Check current user Kazmi786 (ID: 233)
        $user = DB::table('users')->where('id', 233)->first();
        if (!$user) {
            echo "❌ User Kazmi786 (ID: 233) not found!\n";
            return;
        }
        
        echo "✅ Found user: {$user->username} (ID: {$user->id})\n";
        echo "📊 Current ref_id: " . ($user->ref_id ?? 'NULL') . "\n";
        
        // Check how many users have ref_id = 233
        $referralCount = DB::table('users')->where('ref_id', 233)->count();
        echo "👥 Users with ref_id=233: {$referralCount}\n";
        
        // Check referral_links table
        $referralLink = DB::table('referral_links')->where('user_id', 233)->first();
        if ($referralLink) {
            echo "🔗 Found ReferralLink ID: {$referralLink->id} with code: {$referralLink->code}\n";
            
            // Check referral_relationships
            $relationshipCount = DB::table('referral_relationships')
                ->where('referral_link_id', $referralLink->id)
                ->count();
            echo "🔗 ReferralRelationships count: {$relationshipCount}\n";
        } else {
            echo "❌ No ReferralLink found for user {$user->username}\n";
        }
        
        // Check if there are users that should be referrals
        $potentialReferrals = DB::table('users')
            ->where('id', '!=', 233)
            ->where('created_at', '>=', now()->subDays(30))
            ->get();
            
        echo "🔍 Checking recent users for potential referrals...\n";
        foreach ($potentialReferrals as $potentialUser) {
            echo "  - User: {$potentialUser->username} (ID: {$potentialUser->id}), ref_id: " . ($potentialUser->ref_id ?? 'NULL') . "\n";
        }
        
        // Check if referral system is enabled
        $signUpReferral = DB::table('settings')->where('key', 'sign_up_referral')->first();
        if ($signUpReferral) {
            echo "⚙️ sign_up_referral setting: " . ($signUpReferral->value ?? 'NULL') . "\n";
        } else {
            echo "❌ sign_up_referral setting not found!\n";
        }
        
        echo "\n🎯 Summary:\n";
        echo "  - Direct ref_id count: {$referralCount}\n";
        echo "  - ReferralLink exists: " . ($referralLink ? 'Yes' : 'No') . "\n";
        echo "  - ReferralRelationships: {$relationshipCount}\n";
        
        if ($referralCount == 0) {
            echo "\n⚠️ ISSUE IDENTIFIED: No users have ref_id=233\n";
            echo "💡 This means the referral system is not properly setting ref_id during registration\n";
        }
        
        echo "\n🔧 Referral count should work after fixing the registration process!\n";
    }
}

