<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ReferralLink;
use App\Models\ReferralRelationship;
use App\Models\User;

class FixReferralRelationshipsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get user Kazmi786 (ID: 233)
        $user = User::find(233);
        if (!$user) {
            echo "User Kazmi786 not found!\n";
            return;
        }

        // Get ReferralLink for this user
        $referralLink = ReferralLink::where('user_id', $user->id)->first();
        if (!$referralLink) {
            echo "ReferralLink not found for user {$user->username}!\n";
            return;
        }

        echo "Found ReferralLink ID: {$referralLink->id} for user: {$user->username}\n";

        // Find all users with ref_id = 233 (Kazmi786)
        $referredUsers = User::where('ref_id', $user->id)->get();
        echo "Found {$referredUsers->count()} users with ref_id = {$user->id}\n";

        // Create ReferralRelationship for each referred user
        foreach ($referredUsers as $referredUser) {
            // Check if relationship already exists
            $existingRelationship = ReferralRelationship::where([
                'referral_link_id' => $referralLink->id,
                'user_id' => $referredUser->id
            ])->first();

            if (!$existingRelationship) {
                // Create new relationship
                ReferralRelationship::create([
                    'referral_link_id' => $referralLink->id,
                    'user_id' => $referredUser->id,
                ]);
                echo "Created ReferralRelationship for user: {$referredUser->username}\n";
            } else {
                echo "ReferralRelationship already exists for user: {$referredUser->username}\n";
            }
        }

        // Verify final count
        $finalCount = ReferralRelationship::where('referral_link_id', $referralLink->id)->count();
        echo "Final ReferralRelationship count: {$finalCount}\n";

        echo "Referral relationships fixed!\n";
    }
}

