<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ManualPaymentGateway;

class ManualPaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $gateways = [
            [
                'name' => 'BEP20',
                'code' => 'bep20',
                'wallet_address' => '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                'qr_code' => 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                'payment_instructions' => 'Send USDT to the wallet address above using BEP20 network',
                'network' => 'BEP20',
                'minimum_amount' => 10.00,
                'maximum_amount' => 10000.00,
                'fee_percentage' => 0.00,
                'fee_fixed' => 0.00,
                'currency' => 'USDT',
                'currency_symbol' => '$',
                'status' => true,
                'sort_order' => 1
            ],
            [
                'name' => 'Bitcoin',
                'code' => 'bitcoin',
                'wallet_address' => '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                'qr_code' => 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                'payment_instructions' => 'Send BTC to the wallet address above',
                'network' => 'Bitcoin',
                'minimum_amount' => 0.001,
                'maximum_amount' => 10.00,
                'fee_percentage' => 0.00,
                'fee_fixed' => 0.00,
                'currency' => 'BTC',
                'currency_symbol' => '₿',
                'status' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'Ethereum',
                'code' => 'ethereum',
                'wallet_address' => '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                'qr_code' => 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                'payment_instructions' => 'Send ETH to the wallet address above using Ethereum network',
                'network' => 'Ethereum',
                'minimum_amount' => 0.01,
                'maximum_amount' => 100.00,
                'fee_percentage' => 0.00,
                'fee_fixed' => 0.00,
                'currency' => 'ETH',
                'currency_symbol' => 'Ξ',
                'status' => true,
                'sort_order' => 3
            ]
        ];

        foreach ($gateways as $gateway) {
            ManualPaymentGateway::updateOrCreate(
                ['code' => $gateway['code']],
                $gateway
            );
        }
    }
}
