<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ScheduleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $schedules = [
            ['name' => 'Minute', 'time' => 1],
            ['name' => '5 Minutes', 'time' => 5],
            ['name' => '10 Minutes', 'time' => 10],
            ['name' => '15 Minutes', 'time' => 15],
            ['name' => '30 Minutes', 'time' => 30],
            ['name' => 'Hour', 'time' => 60],
            ['name' => 'Daily', 'time' => 1440],
            ['name' => 'Weekly', 'time' => 10080],
            ['name' => 'Monthly', 'time' => 43200],
        ];

        foreach ($schedules as $schedule) {
            \App\Models\Schedule::create($schedule);
        }
    }
}
