<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cookie;

class TestReferralSystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        echo "🧪 Testing Referral System...\n";
        
        // Step 1: Check current referral status
        $kazmi786 = DB::table('users')->where('id', 233)->first();
        echo "👤 Kazmi786 (ID: 233): ref_id = " . ($kazmi786->ref_id ?? 'NULL') . "\n";
        
        $referralCount = DB::table('users')->where('ref_id', 233)->count();
        echo "👥 Current referrals for Kazmi786: {$referralCount}\n";
        
        // Step 2: Check referral link
        $referralLink = DB::table('referral_links')->where('user_id', 233)->first();
        if ($referralLink) {
            echo "🔗 Referral Link: {$referralLink->code}\n";
            echo "🔗 Referral Link ID: {$referralLink->id}\n";
        }
        
        // Step 3: Test referral flow
        echo "\n🔍 Testing Referral Flow:\n";
        
        // Simulate visiting referral link
        $inviteCode = $referralLink->code ?? 'testcode';
        echo "  - User visits: /register?invite={$inviteCode}\n";
        
        // Check if referral link exists
        $referralExists = DB::table('referral_links')->where('code', $inviteCode)->exists();
        echo "  - Referral link exists: " . ($referralExists ? 'Yes' : 'No') . "\n";
        
        if ($referralExists) {
            $referral = DB::table('referral_links')->where('code', $inviteCode)->first();
            echo "  - Referral user ID: {$referral->user_id}\n";
            echo "  - Referral user exists: " . (DB::table('users')->where('id', $referral->user_id)->exists() ? 'Yes' : 'No') . "\n";
        }
        
        // Step 4: Check recent users
        echo "\n📊 Recent Users (Last 10):\n";
        $recentUsers = DB::table('users')->orderBy('created_at', 'desc')->limit(10)->get();
        foreach ($recentUsers as $user) {
            echo "  - {$user->username} (ID: {$user->id}): ref_id = " . ($user->ref_id ?? 'NULL') . "\n";
        }
        
        // Step 5: Test referral creation
        echo "\n🧪 Testing Referral Creation:\n";
        
        // Create a test user with referral
        $testUsername = 'testreferral_' . time();
        $testEmail = $testUsername . '@test.com';
        
        try {
            $userId = DB::table('users')->insertGetId([
                'username' => $testUsername,
                'email' => $testEmail,
                'first_name' => 'Test',
                'last_name' => 'Referral',
                'password' => bcrypt('password123'),
                'ref_id' => 233, // Kazmi786
                'ranking_id' => 1,
                'rankings' => json_encode([1]),
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            
            echo "  ✅ Created test user: {$testUsername} (ID: {$userId}) with ref_id: 233\n";
            
            // Verify referral count increased
            $newReferralCount = DB::table('users')->where('ref_id', 233)->count();
            echo "  📊 New referral count: {$newReferralCount}\n";
            
            if ($newReferralCount > $referralCount) {
                echo "  🎉 SUCCESS: Referral count increased!\n";
            } else {
                echo "  ❌ FAILED: Referral count did not increase\n";
            }
            
        } catch (\Exception $e) {
            echo "  ❌ ERROR creating test user: " . $e->getMessage() . "\n";
        }
        
        echo "\n🎯 Summary:\n";
        echo "  - Kazmi786 referrals: {$referralCount} → {$newReferralCount}\n";
        echo "  - Referral system should work if count increased\n";
        echo "  - Check achievement and referral pages after this test\n";
    }
}

