@extends('backend.layouts.app')

@section('title', 'Create Deposit Method')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-plus-circle me-2"></i>
                        Create New Deposit Method
                    </h4>
                    <p class="mb-0 text-white-50">Add a new payment method for user deposits</p>
                </div>
                
                <div class="card-body p-4">
                    <form action="{{ route('admin.deposit-methods.store') }}" method="POST" id="depositMethodForm" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- Basic Information Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-info-circle me-2"></i>
                                    Basic Information
                                </h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label fw-bold">
                                    Method Name <span class="text-danger">*</span>
                                </label>
                                <input type="text" 
                                       class="form-control form-control-lg @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}" 
                                       placeholder="e.g., Bank Transfer, Bitcoin, PayPal"
                                       required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="gateway_code" class="form-label fw-bold">
                                    Gateway Code <span class="text-danger">*</span>
                                </label>
                                <div class="input-group input-group-lg">
                                    <input type="text" 
                                           class="form-control @error('gateway_code') is-invalid @enderror" 
                                           id="gateway_code" 
                                           name="gateway_code" 
                                           value="{{ old('gateway_code') }}" 
                                           placeholder="e.g., bank_transfer_001"
                                           required>
                                    <button type="button" 
                                            class="btn btn-outline-primary" 
                                            onclick="generateGatewayCode()"
                                            title="Generate Unique Code">
                                        <i class="fas fa-magic"></i>
                                    </button>
                                </div>
                                <small class="form-text text-muted">
                                    <i class="fas fa-lightbulb me-1"></i>
                                    Use a unique identifier for this payment method
                                </small>
                                @error('gateway_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="type" class="form-label fw-bold">
                                    Payment Type <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form-select-lg @error('type') is-invalid @enderror" 
                                        id="type" 
                                        name="type" 
                                        required>
                                    <option value="">Select Type</option>
                                    <option value="manual" {{ old('type') == 'manual' ? 'selected' : '' }}>
                                        Manual Processing
                                    </option>
                                    <option value="auto" {{ old('type') == 'auto' ? 'selected' : '' }}>
                                        Automatic Processing
                                    </option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label fw-bold">
                                    Status <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form-select-lg @error('status') is-invalid @enderror" 
                                        id="status" 
                                        name="status" 
                                        required>
                                    <option value="">Select Status</option>
                                    <option value="1" {{ old('status') == '1' ? 'selected' : '' }}>
                                        <i class="fas fa-check-circle text-success me-1"></i>Active
                                    </option>
                                    <option value="0" {{ old('status') == '0' ? 'selected' : '' }}>
                                        <i class="fas fa-times-circle text-danger me-1"></i>Inactive
                                    </option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="logo" class="form-label fw-bold">
                                    Method Logo
                                </label>
                                <input type="file" 
                                       class="form-control form-control-lg @error('logo') is-invalid @enderror" 
                                       id="logo" 
                                       name="logo" 
                                       accept="image/*">
                                <small class="form-text text-muted">
                                    <i class="fas fa-image me-1"></i>
                                    Upload a logo for this payment method (PNG, JPG, SVG)
                                </small>
                                @error('logo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Payment Configuration Section -->
                        <div class="row mb-4" id="paymentConfigSection" style="display: none;">
                            <div class="col-12">
                                <h5 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-cog me-2"></i>
                                    Payment Configuration
                                </h5>
                            </div>
                        </div>

                        <div class="row" id="paymentTypeRow" style="display: none;">
                            <div class="col-md-6 mb-3">
                                <label for="payment_type" class="form-label fw-bold">
                                    Payment Method <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form-select-lg @error('payment_type') is-invalid @enderror" 
                                        id="payment_type" 
                                        name="payment_type">
                                    <option value="">Select Payment Method</option>
                                    <option value="bank_transfer" {{ old('payment_type') == 'bank_transfer' ? 'selected' : '' }}>
                                        <i class="fas fa-university me-1"></i>Bank Transfer
                                    </option>
                                    <option value="crypto" {{ old('payment_type') == 'crypto' ? 'selected' : '' }}>
                                        <i class="fas fa-coins me-1"></i>Cryptocurrency
                                    </option>
                                </select>
                                @error('payment_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Bank Transfer Fields -->
                        <div class="row" id="bankTransferFields" style="display: none;">
                            <div class="col-12">
                                <div class="card border-info">
                                    <div class="card-header bg-info text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-university me-2"></i>
                                            Bank Transfer Details
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="account_number" class="form-label fw-bold">Account Number</label>
                                                <input type="text" 
                                                       class="form-control @error('account_number') is-invalid @enderror" 
                                                       id="account_number" 
                                                       name="account_number" 
                                                       value="{{ old('account_number') }}"
                                                       placeholder="Enter account number">
                                                @error('account_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="account_name" class="form-label fw-bold">Account Name</label>
                                                <input type="text" 
                                                       class="form-control @error('account_name') is-invalid @enderror" 
                                                       id="account_name" 
                                                       name="account_name" 
                                                       value="{{ old('account_name') }}"
                                                       placeholder="Enter account holder name">
                                                @error('account_name')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="bank_name" class="form-label fw-bold">Bank Name</label>
                                                <input type="text" 
                                                       class="form-control @error('bank_name') is-invalid @enderror" 
                                                       id="bank_name" 
                                                       name="bank_name" 
                                                       value="{{ old('bank_name') }}"
                                                       placeholder="Enter bank name">
                                                @error('bank_name')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="routing_number" class="form-label fw-bold">Routing Number</label>
                                                <input type="text" 
                                                       class="form-control @error('routing_number') is-invalid @enderror" 
                                                       id="routing_number" 
                                                       name="routing_number" 
                                                       value="{{ old('routing_number') }}"
                                                       placeholder="Enter routing number">
                                                @error('routing_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="swift_code" class="form-label fw-bold">SWIFT Code</label>
                                                <input type="text" 
                                                       class="form-control @error('swift_code') is-invalid @enderror" 
                                                       id="swift_code" 
                                                       name="swift_code" 
                                                       value="{{ old('swift_code') }}"
                                                       placeholder="Enter SWIFT code">
                                                @error('swift_code')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Crypto Fields -->
                        <div class="row" id="cryptoFields" style="display: none;">
                            <div class="col-12">
                                <div class="card border-warning">
                                    <div class="card-header bg-warning text-dark">
                                        <h6 class="mb-0">
                                            <i class="fas fa-coins me-2"></i>
                                            Cryptocurrency Details
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="crypto_type" class="form-label fw-bold">Cryptocurrency Type</label>
                                                <select class="form-select @error('crypto_type') is-invalid @enderror" 
                                                        id="crypto_type" 
                                                        name="crypto_type">
                                                    <option value="">Select Cryptocurrency</option>
                                                    <option value="bitcoin" {{ old('crypto_type') == 'bitcoin' ? 'selected' : '' }}>Bitcoin (BTC)</option>
                                                    <option value="ethereum" {{ old('crypto_type') == 'ethereum' ? 'selected' : '' }}>Ethereum (ETH)</option>
                                                    <option value="usdt" {{ old('crypto_type') == 'usdt' ? 'selected' : '' }}>Tether (USDT)</option>
                                                    <option value="usdc" {{ old('crypto_type') == 'usdc' ? 'selected' : '' }}>USD Coin (USDC)</option>
                                                    <option value="binance" {{ old('crypto_type') == 'binance' ? 'selected' : '' }}>Binance Coin (BNB)</option>
                                                    <option value="litecoin" {{ old('crypto_type') == 'litecoin' ? 'selected' : '' }}>Litecoin (LTC)</option>
                                                </select>
                                                @error('crypto_type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="network" class="form-label fw-bold">Network</label>
                                                <select class="form-select @error('network') is-invalid @enderror" 
                                                        id="network" 
                                                        name="network">
                                                    <option value="">Select Network</option>
                                                    <option value="mainnet" {{ old('network') == 'mainnet' ? 'selected' : '' }}>Mainnet</option>
                                                    <option value="testnet" {{ old('network') == 'testnet' ? 'selected' : '' }}>Testnet</option>
                                                    <option value="bep20" {{ old('network') == 'bep20' ? 'selected' : '' }}>BEP20 (BSC)</option>
                                                    <option value="erc20" {{ old('network') == 'erc20' ? 'selected' : '' }}>ERC20 (Ethereum)</option>
                                                    <option value="trc20" {{ old('network') == 'trc20' ? 'selected' : '' }}>TRC20 (TRON)</option>
                                                </select>
                                                @error('network')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-12 mb-3">
                                                <label for="wallet_address" class="form-label fw-bold">Wallet Address</label>
                                                <input type="text" 
                                                       class="form-control @error('wallet_address') is-invalid @enderror" 
                                                       id="wallet_address" 
                                                       name="wallet_address" 
                                                       value="{{ old('wallet_address') }}"
                                                       placeholder="Enter wallet address">
                                                @error('wallet_address')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-12 mb-3">
                                                <label for="qr_code" class="form-label fw-bold">QR Code URL</label>
                                                <input type="url" 
                                                       class="form-control @error('qr_code') is-invalid @enderror" 
                                                       id="qr_code" 
                                                       name="qr_code" 
                                                       value="{{ old('qr_code') }}"
                                                       placeholder="https://example.com/qr-code.png">
                                                @error('qr_code')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Financial Settings Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-dollar-sign me-2"></i>
                                    Financial Settings
                                </h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="minimum_deposit" class="form-label fw-bold">
                                    Minimum Deposit <span class="text-danger">*</span>
                                </label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text">$</span>
                                    <input type="number" 
                                           class="form-control @error('minimum_deposit') is-invalid @enderror" 
                                           id="minimum_deposit" 
                                           name="minimum_deposit" 
                                           value="{{ old('minimum_deposit') }}" 
                                           step="0.01" 
                                           min="0"
                                           placeholder="0.00"
                                           required>
                                </div>
                                @error('minimum_deposit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="maximum_deposit" class="form-label fw-bold">
                                    Maximum Deposit <span class="text-danger">*</span>
                                </label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text">$</span>
                                    <input type="number" 
                                           class="form-control @error('maximum_deposit') is-invalid @enderror" 
                                           id="maximum_deposit" 
                                           name="maximum_deposit" 
                                           value="{{ old('maximum_deposit') }}" 
                                           step="0.01" 
                                           min="0"
                                           placeholder="0.00"
                                           required>
                                </div>
                                @error('maximum_deposit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="charge" class="form-label fw-bold">
                                    Processing Fee <span class="text-danger">*</span>
                                </label>
                                <div class="input-group input-group-lg">
                                    <input type="number" 
                                           class="form-control @error('charge') is-invalid @enderror" 
                                           id="charge" 
                                           name="charge" 
                                           value="{{ old('charge') }}" 
                                           step="0.01" 
                                           min="0"
                                           placeholder="0.00"
                                           required>
                                    <select class="form-select @error('charge_type') is-invalid @enderror" 
                                            id="charge_type" 
                                            name="charge_type" 
                                            required>
                                        <option value="">Type</option>
                                        <option value="fixed" {{ old('charge_type') == 'fixed' ? 'selected' : '' }}>Fixed ($)</option>
                                        <option value="percentage" {{ old('charge_type') == 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                                    </select>
                                </div>
                                @error('charge')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                @error('charge_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="currency" class="form-label fw-bold">
                                    Currency <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form-select-lg @error('currency') is-invalid @enderror" 
                                        id="currency" 
                                        name="currency" 
                                        required>
                                    <option value="">Select Currency</option>
                                    <option value="USD" {{ old('currency') == 'USD' ? 'selected' : '' }}>USD - US Dollar</option>
                                    <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>EUR - Euro</option>
                                    <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>GBP - British Pound</option>
                                    <option value="BTC" {{ old('currency') == 'BTC' ? 'selected' : '' }}>BTC - Bitcoin</option>
                                    <option value="ETH" {{ old('currency') == 'ETH' ? 'selected' : '' }}>ETH - Ethereum</option>
                                </select>
                                @error('currency')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="rate" class="form-label fw-bold">
                                    Exchange Rate <span class="text-danger">*</span>
                                </label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text">1 USD =</span>
                                    <input type="number" 
                                           class="form-control @error('rate') is-invalid @enderror" 
                                           id="rate" 
                                           name="rate" 
                                           value="{{ old('rate') }}" 
                                           step="0.000001" 
                                           min="0"
                                           placeholder="1.00"
                                           required>
                                </div>
                                @error('rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Additional Settings Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-cogs me-2"></i>
                                    Additional Settings
                                </h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 mb-3">
                                <label for="payment_instructions" class="form-label fw-bold">
                                    Payment Instructions
                                </label>
                                <textarea class="form-control @error('payment_instructions') is-invalid @enderror" 
                                          id="payment_instructions" 
                                          name="payment_instructions" 
                                          rows="4"
                                          placeholder="Enter detailed payment instructions for users...">{{ old('payment_instructions') }}</textarea>
                                @error('payment_instructions')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.deposit-methods.index') }}" 
                                       class="btn btn-secondary btn-lg">
                                        <i class="fas fa-arrow-left me-2"></i>
                                        Back to List
                                    </a>
                                    <div>
                                        <button type="button" 
                                                class="btn btn-outline-primary btn-lg me-2" 
                                                onclick="resetForm()">
                                            <i class="fas fa-undo me-2"></i>
                                            Reset Form
                                        </button>
                                        <button type="submit" 
                                                class="btn btn-primary btn-lg">
                                            <i class="fas fa-save me-2"></i>
                                            Create Method
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .card {
        border: none;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        border-radius: 0.5rem;
    }
    
    .card-header {
        border-radius: 0.5rem 0.5rem 0 0 !important;
        border-bottom: none;
    }
    
    .form-control, .form-select {
        border-radius: 0.375rem;
        border: 1px solid #dee2e6;
        transition: all 0.15s ease-in-out;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .form-control-lg, .form-select-lg {
        padding: 0.75rem 1rem;
        font-size: 1.1rem;
    }
    
    .btn {
        border-radius: 0.375rem;
        font-weight: 500;
        transition: all 0.15s ease-in-out;
    }
    
    .btn-lg {
        padding: 0.75rem 1.5rem;
        font-size: 1.1rem;
    }
    
    .border-info {
        border-color: #0dcaf0 !important;
    }
    
    .border-warning {
        border-color: #ffc107 !important;
    }
    
    .text-primary {
        color: #0d6efd !important;
    }
    
    .fade-in {
        animation: fadeIn 0.3s ease-in-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    .slide-down {
        animation: slideDown 0.3s ease-in-out;
    }
    
    @keyframes slideDown {
        from { opacity: 0; max-height: 0; }
        to { opacity: 1; max-height: 500px; }
    }
</style>
@endpush

@push('scripts')
<script>
// Generate unique gateway code
function generateGatewayCode() {
    const name = document.getElementById('name').value.toLowerCase().replace(/[^a-z0-9]/g, '_');
    const type = document.getElementById('type').value;
    const paymentType = document.getElementById('payment_type').value;
    
    let code = '';
    const randomSuffix = Math.random().toString(36).substr(2, 6);
    
    if (type === 'manual') {
        if (paymentType === 'bank_transfer') {
            code = 'bank_transfer_' + randomSuffix;
        } else if (paymentType === 'crypto') {
            const cryptoType = document.getElementById('crypto_type').value || 'crypto';
            code = cryptoType + '_' + randomSuffix;
        } else {
            code = 'manual_' + randomSuffix;
        }
    } else {
        code = 'auto_' + randomSuffix;
    }
    
    document.getElementById('gateway_code').value = code;
    
    // Add visual feedback
    const input = document.getElementById('gateway_code');
    input.classList.add('border-success');
    setTimeout(() => {
        input.classList.remove('border-success');
    }, 2000);
}

// Toggle payment type fields
function togglePaymentTypeFields() {
    const type = document.getElementById('type').value;
    const paymentConfigSection = document.getElementById('paymentConfigSection');
    const paymentTypeRow = document.getElementById('paymentTypeRow');
    
    if (type === 'manual') {
        paymentConfigSection.style.display = 'block';
        paymentTypeRow.style.display = 'block';
        paymentConfigSection.classList.add('fade-in');
    } else {
        paymentConfigSection.style.display = 'none';
        paymentTypeRow.style.display = 'none';
        // Hide all payment fields
        document.getElementById('bankTransferFields').style.display = 'none';
        document.getElementById('cryptoFields').style.display = 'none';
    }
}

// Toggle payment method fields
function togglePaymentFields() {
    const paymentType = document.getElementById('payment_type').value;
    const bankFields = document.getElementById('bankTransferFields');
    const cryptoFields = document.getElementById('cryptoFields');
    
    // Hide all fields first
    bankFields.style.display = 'none';
    cryptoFields.style.display = 'none';
    
    // Show relevant fields
    if (paymentType === 'bank_transfer') {
        bankFields.style.display = 'block';
        bankFields.classList.add('slide-down');
    } else if (paymentType === 'crypto') {
        cryptoFields.style.display = 'block';
        cryptoFields.classList.add('slide-down');
    }
}

// Reset form
function resetForm() {
    if (confirm('Are you sure you want to reset the form? All data will be lost.')) {
        document.getElementById('depositMethodForm').reset();
        document.getElementById('bankTransferFields').style.display = 'none';
        document.getElementById('cryptoFields').style.display = 'none';
        document.getElementById('paymentConfigSection').style.display = 'none';
        document.getElementById('paymentTypeRow').style.display = 'none';
    }
}

// Form validation
function validateForm() {
    const type = document.getElementById('type').value;
    const paymentType = document.getElementById('payment_type').value;
    
    if (type === 'manual' && !paymentType) {
        alert('Please select a payment method for manual processing.');
        return false;
    }
    
    return true;
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    // Add event listeners
    document.getElementById('type').addEventListener('change', function() {
        togglePaymentTypeFields();
        generateGatewayCode();
    });
    
    document.getElementById('payment_type').addEventListener('change', function() {
        togglePaymentFields();
        generateGatewayCode();
    });
    
    document.getElementById('crypto_type').addEventListener('change', generateGatewayCode);
    document.getElementById('name').addEventListener('blur', generateGatewayCode);
    
    // Form submission
    document.getElementById('depositMethodForm').addEventListener('submit', function(e) {
        if (!validateForm()) {
            e.preventDefault();
        }
    });
    
    // Initialize form state
    togglePaymentTypeFields();
    togglePaymentFields();
});
</script>
@endpush