@extends('backend.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Pending Deposit Requests</h4>
                    <p class="card-subtitle">Review and approve manual deposit requests</p>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>User</th>
                                    <th>Amount</th>
                                    <th>Payment Method</th>
                                    <th>Transaction Hash</th>
                                    <th>Proof File</th>
                                    <th>Submitted At</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($deposits as $deposit)
                                <tr>
                                    <td>#{{ $deposit->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm me-2">
                                                <div class="avatar-title bg-primary text-white rounded-circle">
                                                    {{ substr($deposit->user->username, 0, 1) }}
                                                </div>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $deposit->user->username }}</h6>
                                                <small class="text-muted">{{ $deposit->user->email }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="fw-bold text-success">
                                            {{ setting('currency_symbol', 'global') }}{{ number_format($deposit->amount, 2) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">
                                            {{ ucfirst(json_decode($deposit->manual_data, true)['payment_method'] ?? 'N/A') }}
                                        </span>
                                    </td>
                                    <td>
                                        <code>{{ json_decode($deposit->manual_data, true)['transaction_hash'] ?? 'N/A' }}</code>
                                    </td>
                                    <td>
                                        @if(isset(json_decode($deposit->manual_data, true)['proof_file']))
                                        <a href="{{ asset('assets/' . json_decode($deposit->manual_data, true)['proof_file']) }}" 
                                           target="_blank" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        @else
                                        <span class="text-muted">No file</span>
                                        @endif
                                    </td>
                                    <td>{{ $deposit->created_at->format('M d, Y H:i') }}</td>
                                    <td>
                                        <span class="badge bg-warning">Pending</span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-success" 
                                                    onclick="approveDeposit({{ $deposit->id }})">
                                                <i class="fas fa-check"></i> Approve
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="rejectDeposit({{ $deposit->id }})">
                                                <i class="fas fa-times"></i> Reject
                                            </button>
                                            <button type="button" class="btn btn-sm btn-info" 
                                                    onclick="viewDetails({{ $deposit->id }})">
                                                <i class="fas fa-info"></i> Details
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-inbox fa-3x mb-3"></i>
                                            <p>No pending deposit requests found</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    @if($deposits->hasPages())
                    <div class="d-flex justify-content-center mt-3">
                        {{ $deposits->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Deposit Details Modal -->
<div class="modal fade" id="depositDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Deposit Request Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="depositDetailsContent">
                <!-- Content will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Approval Modal -->
<div class="modal fade" id="approvalModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="approvalModalTitle">Confirm Action</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="approvalForm">
                    @csrf
                    <input type="hidden" id="depositId" name="deposit_id">
                    <input type="hidden" id="actionType" name="action_type">
                    
                    <div class="mb-3">
                        <label for="adminNotes" class="form-label">Admin Notes (Optional)</label>
                        <textarea class="form-control" id="adminNotes" name="admin_notes" rows="3" 
                                  placeholder="Add any notes about this action..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn" id="confirmActionBtn">Confirm</button>
            </div>
        </div>
    </div>
</div>

<style>
.avatar-sm {
    width: 40px;
    height: 40px;
}

.avatar-title {
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
}

.btn-group .btn {
    margin-right: 5px;
}

.btn-group .btn:last-child {
    margin-right: 0;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table td {
    vertical-align: middle;
}

.badge {
    font-size: 0.75em;
}

code {
    background: #f8f9fa;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 0.875em;
}
</style>

<script>
function approveDeposit(depositId) {
    document.getElementById('depositId').value = depositId;
    document.getElementById('actionType').value = 'approve';
    document.getElementById('approvalModalTitle').textContent = 'Approve Deposit';
    document.getElementById('confirmActionBtn').textContent = 'Approve';
    document.getElementById('confirmActionBtn').className = 'btn btn-success';
    
    new bootstrap.Modal(document.getElementById('approvalModal')).show();
}

function rejectDeposit(depositId) {
    document.getElementById('depositId').value = depositId;
    document.getElementById('actionType').value = 'reject';
    document.getElementById('approvalModalTitle').textContent = 'Reject Deposit';
    document.getElementById('confirmActionBtn').textContent = 'Reject';
    document.getElementById('confirmActionBtn').className = 'btn btn-danger';
    
    new bootstrap.Modal(document.getElementById('approvalModal')).show();
}

function viewDetails(depositId) {
    // Load deposit details via AJAX
    fetch(`/admin/deposit/details/${depositId}`)
        .then(response => response.text())
        .then(html => {
            document.getElementById('depositDetailsContent').innerHTML = html;
            new bootstrap.Modal(document.getElementById('depositDetailsModal')).show();
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error loading deposit details');
        });
}

document.getElementById('confirmActionBtn').addEventListener('click', function() {
    const form = document.getElementById('approvalForm');
    const formData = new FormData(form);
    
    fetch('/admin/deposit/action', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error processing request');
    });
});
</script>
@endsection

