@extends('backend.layouts.app')

@section('title', 'Edit Schedule')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Schedule</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.schedules.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.schedules.update', $schedule) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Schedule Name</label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $schedule->name) }}" required>
                                    @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="time">Time (Minutes)</label>
                                    <input type="number" class="form-control" id="time" name="time" value="{{ old('time', $schedule->time) }}" min="1" required>
                                    <small class="form-text text-muted">Enter time in minutes (e.g., 60 for 1 hour, 1440 for 1 day)</small>
                                    @error('time')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="status" name="status" value="1" {{ old('status', $schedule->status) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="status">
                                            Active
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Schedule
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Auto-update display when time changes
document.getElementById('time').addEventListener('input', function() {
    const time = parseInt(this.value);
    if (time) {
        let display = '';
        if (time < 60) {
            display = time + ' minutes';
        } else if (time < 1440) {
            display = (time / 60).toFixed(1) + ' hours';
        } else {
            display = (time / 1440).toFixed(1) + ' days';
        }
        this.nextElementSibling.textContent = 'Enter time in minutes (e.g., 60 for 1 hour, 1440 for 1 day) - ' + display;
    }
});
</script>
@endsection
