@extends('backend.layouts.app')
@section('title')
{{ __('Theme Management') }}
@endsection
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ __('Theme Management') }}</h4>
                    <p class="card-subtitle">{{ __('Select and manage your site themes') }}</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($themes as $theme)
                        <div class="col-md-4 mb-4">
                            <div class="theme-card {{ $theme->status ? 'active' : '' }}">
                                <div class="theme-preview">
                                    @if($theme->name === 'default')
                                        <div class="preview-default">
                                            <div class="preview-header"></div>
                                            <div class="preview-content">
                                                <div class="preview-card"></div>
                                                <div class="preview-card"></div>
                                                <div class="preview-card"></div>
                                            </div>
                                        </div>
                                    @elseif($theme->name === 'investify')
                                        <div class="preview-investify">
                                            <div class="preview-header-dark"></div>
                                            <div class="preview-content-dark">
                                                <div class="preview-card-dark"></div>
                                                <div class="preview-card-dark"></div>
                                                <div class="preview-card-dark"></div>
                                            </div>
                                        </div>
                                    @elseif($theme->name === 'shahdeveloper')
                                        <div class="preview-shahdeveloper">
                                            <div class="preview-header-gradient"></div>
                                            <div class="preview-content-gradient">
                                                <div class="preview-card-gradient"></div>
                                                <div class="preview-card-gradient"></div>
                                                <div class="preview-card-gradient"></div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="theme-info">
                                    <h5 class="theme-name">{{ ucfirst($theme->name) }}</h5>
                                    <p class="theme-description">
                                        @if($theme->name === 'default')
                                            Default clean and simple theme
                                        @elseif($theme->name === 'investify')
                                            Modern investment theme with dark design
                                        @elseif($theme->name === 'shahdeveloper')
                                            InvestFlow inspired theme with glassmorphism
                                        @endif
                                    </p>
                                    <div class="theme-actions">
                                        @if($theme->status)
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <button class="btn btn-primary btn-sm activate-theme" 
                                                    data-theme-id="{{ $theme->id }}">
                                                Activate
                                            </button>
                                        @endif
                                        <a href="{{ route('admin.theme.preview', $theme->id) }}" 
                                           class="btn btn-outline-secondary btn-sm">
                                            Preview
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.theme-card {
    border: 2px solid #e9ecef;
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
    background: white;
}

.theme-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.theme-card.active {
    border-color: #007bff;
    box-shadow: 0 0 0 3px rgba(0,123,255,0.1);
}

.theme-preview {
    height: 200px;
    background: #f8f9fa;
    position: relative;
    overflow: hidden;
}

.preview-default {
    height: 100%;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.preview-investify {
    height: 100%;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
}

.preview-shahdeveloper {
    height: 100%;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 100%);
}

.preview-header {
    height: 40px;
    background: #007bff;
    margin: 10px;
    border-radius: 4px;
}

.preview-header-dark {
    height: 40px;
    background: rgba(255,255,255,0.1);
    margin: 10px;
    border-radius: 4px;
    backdrop-filter: blur(10px);
}

.preview-header-gradient {
    height: 40px;
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
    margin: 10px;
    border-radius: 4px;
}

.preview-content {
    padding: 10px;
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.preview-content-dark {
    padding: 10px;
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.preview-content-gradient {
    padding: 10px;
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.preview-card {
    height: 30px;
    background: white;
    border-radius: 4px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.preview-card-dark {
    height: 30px;
    background: rgba(255,255,255,0.05);
    border-radius: 4px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.1);
}

.preview-card-gradient {
    height: 30px;
    background: rgba(255,255,255,0.05);
    border-radius: 4px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.1);
}

.theme-info {
    padding: 20px;
}

.theme-name {
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
}

.theme-description {
    color: #666;
    font-size: 0.9rem;
    margin-bottom: 15px;
}

.theme-actions {
    display: flex;
    gap: 10px;
    align-items: center;
}

.badge-success {
    background: #28a745;
    color: white;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.8rem;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle theme activation
    document.querySelectorAll('.activate-theme').forEach(button => {
        button.addEventListener('click', function() {
            const themeId = this.dataset.themeId;
            
            if (confirm('Are you sure you want to activate this theme?')) {
                fetch('{{ route("admin.theme.activate") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        theme_id: themeId
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while activating the theme.');
                });
            }
        });
    });
});
</script>
@endsection
