@extends('backend.layouts.app')

@section('title', 'Edit Withdraw Method')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Withdraw Method</h3>
                    <a href="{{ route('admin.withdraw.methods.index') }}" class="btn btn-secondary float-right">
                        <i class="fas fa-arrow-left"></i> Back to Methods
                    </a>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.withdraw.methods.update', $method) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Method Name *</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name', $method->name) }}" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">Method Type *</label>
                                    <select class="form-control @error('type') is-invalid @enderror" 
                                            id="type" name="type" required>
                                        <option value="">Select Type</option>
                                        <option value="crypto" {{ old('type', $method->type) == 'crypto' ? 'selected' : '' }}>Cryptocurrency</option>
                                        <option value="banking" {{ old('type', $method->type) == 'banking' ? 'selected' : '' }}>Banking</option>
                                        <option value="mobile" {{ old('type', $method->type) == 'mobile' ? 'selected' : '' }}>Mobile Payment</option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="icon">Icon</label>
                                    <input type="text" class="form-control @error('icon') is-invalid @enderror" 
                                           id="icon" name="icon" value="{{ old('icon', $method->icon) }}" 
                                           placeholder="e.g., ₿, Ξ, 📱, 🏦">
                                    <small class="form-text text-muted">You can use emoji or icon class</small>
                                    @error('icon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sort_order">Sort Order</label>
                                    <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                                           id="sort_order" name="sort_order" value="{{ old('sort_order', $method->sort_order) }}" min="0">
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_amount">Minimum Amount *</label>
                                    <input type="number" class="form-control @error('min_amount') is-invalid @enderror" 
                                           id="min_amount" name="min_amount" value="{{ old('min_amount', $method->min_amount) }}" 
                                           step="0.01" min="0" required>
                                    @error('min_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_amount">Maximum Amount *</label>
                                    <input type="number" class="form-control @error('max_amount') is-invalid @enderror" 
                                           id="max_amount" name="max_amount" value="{{ old('max_amount', $method->max_amount) }}" 
                                           step="0.01" min="0" required>
                                    @error('max_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fee_percentage">Fee Percentage *</label>
                                    <input type="number" class="form-control @error('fee_percentage') is-invalid @enderror" 
                                           id="fee_percentage" name="fee_percentage" value="{{ old('fee_percentage', $method->fee_percentage) }}" 
                                           step="0.01" min="0" max="100" required>
                                    <small class="form-text text-muted">Percentage fee (0-100)</small>
                                    @error('fee_percentage')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fee_fixed">Fixed Fee *</label>
                                    <input type="number" class="form-control @error('fee_fixed') is-invalid @enderror" 
                                           id="fee_fixed" name="fee_fixed" value="{{ old('fee_fixed', $method->fee_fixed) }}" 
                                           step="0.01" min="0" required>
                                    <small class="form-text text-muted">Fixed fee amount</small>
                                    @error('fee_fixed')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="required_fields">Required Fields</label>
                            <div class="row">
                                @php
                                    $selectedFields = old('required_fields', $method->required_fields ?? []);
                                @endphp
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="wallet_address" 
                                               {{ in_array('wallet_address', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Wallet Address</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="network_type" 
                                               {{ in_array('network_type', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Network Type</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="account_title" 
                                               {{ in_array('account_title', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Account Title</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="account_number" 
                                               {{ in_array('account_number', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Account Number</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="bank_name" 
                                               {{ in_array('bank_name', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Bank Name</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="branch_code" 
                                               {{ in_array('branch_code', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Branch Code</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="mobile_number" 
                                               {{ in_array('mobile_number', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Mobile Number</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="required_fields[]" value="account_name" 
                                               {{ in_array('account_name', $selectedFields) ? 'checked' : '' }}>
                                        <label class="form-check-label">Account Name</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="instructions">Instructions</label>
                            <textarea class="form-control @error('instructions') is-invalid @enderror" 
                                      id="instructions" name="instructions" rows="3" 
                                      placeholder="Instructions for users">{{ old('instructions', $method->instructions) }}</textarea>
                            @error('instructions')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" name="is_active" value="1" 
                                       {{ old('is_active', $method->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label">Active</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Method
                            </button>
                            <a href="{{ route('admin.withdraw.methods.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

