@extends('backend.layouts.app')

@section('title', 'Withdraw Requests')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Withdraw Requests</h3>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <form method="GET" action="{{ route('admin.withdraw.requests.index') }}">
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="status" class="form-control" onchange="this.form.submit()">
                                        <option value="">All Status</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                        <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                                    </select>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-3">
                            <form method="GET" action="{{ route('admin.withdraw.requests.index') }}">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" class="form-control" onchange="this.form.submit()">
                                        <option value="">All Methods</option>
                                        @foreach($methods as $method)
                                        <option value="{{ $method->id }}" {{ request('method') == $method->id ? 'selected' : '' }}>
                                            {{ $method->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-6">
                            <form method="GET" action="{{ route('admin.withdraw.requests.index') }}">
                                <div class="form-group">
                                    <label>Search User</label>
                                    <div class="input-group">
                                        <input type="text" name="search" class="form-control" 
                                               placeholder="Search by username, email, or name" 
                                               value="{{ request('search') }}">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert">
                                <span>&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>User</th>
                                    <th>Method</th>
                                    <th>Amount</th>
                                    <th>Fee</th>
                                    <th>Final Amount</th>
                                    <th>Wallet</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($requests as $request)
                                <tr>
                                    <td>{{ $request->id }}</td>
                                    <td>
                                        <div>
                                            <strong>{{ $request->user->first_name }} {{ $request->user->last_name }}</strong><br>
                                            <small class="text-muted">{{ $request->user->username }} ({{ $request->user->email }})</small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $request->withdrawMethod->type === 'crypto' ? 'warning' : ($request->withdrawMethod->type === 'banking' ? 'info' : 'success') }}">
                                            {{ $request->withdrawMethod->name }}
                                        </span>
                                    </td>
                                    <td>${{ number_format($request->amount, 2) }}</td>
                                    <td>${{ number_format($request->fee, 2) }}</td>
                                    <td>${{ number_format($request->final_amount, 2) }}</td>
                                    <td>
                                        <span class="badge badge-{{ $request->wallet_type === 'main' ? 'primary' : 'success' }}">
                                            {{ ucfirst($request->wallet_type) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $request->status_badge }}">
                                            {{ ucfirst($request->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $request->created_at->format('M d, Y h:i A') }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.withdraw.requests.show', $request) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($request->status === 'pending')
                                            <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#approveModal{{ $request->id }}">
                                                <i class="fas fa-check"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#rejectModal{{ $request->id }}">
                                                <i class="fas fa-times"></i>
                                            </button>
                                            @elseif($request->status === 'approved')
                                            <form action="{{ route('admin.withdraw.requests.complete', $request) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Mark as completed?')">
                                                    <i class="fas fa-check-double"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center">No withdraw requests found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center">
                        {{ $requests->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->
@foreach($requests as $request)
@if($request->status === 'pending')
<div class="modal fade" id="approveModal{{ $request->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.withdraw.requests.approve', $request) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Approve Withdraw Request</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to approve this withdraw request?</p>
                    <div class="form-group">
                        <label for="admin_note">Admin Note (Optional)</label>
                        <textarea class="form-control" name="admin_note" rows="3" placeholder="Add a note for the user"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="rejectModal{{ $request->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.withdraw.requests.reject', $request) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Reject Withdraw Request</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to reject this withdraw request?</p>
                    <div class="form-group">
                        <label for="rejection_reason">Rejection Reason *</label>
                        <textarea class="form-control @error('rejection_reason') is-invalid @enderror" 
                                  name="rejection_reason" rows="3" placeholder="Please provide a reason for rejection" required></textarea>
                        @error('rejection_reason')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
@endforeach
@endsection

