@extends('backend.layouts.app')
@section('title', 'Create Announcement')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">Create New Announcement</h3>
                    <div class="card-header-links">
                        <a href="{{ route('admin.announcement.index') }}" class="card-header-link">
                            <i icon-name="arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="site-card-body">
                    <form action="{{ route('admin.announcement.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="title">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                           id="title" name="title" value="{{ old('title') }}" required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="message">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('message') is-invalid @enderror" 
                                              id="message" name="message" rows="6" required>{{ old('message') }}</textarea>
                                    @error('message')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="type">Type <span class="text-danger">*</span></label>
                                    <select class="form-control @error('type') is-invalid @enderror" id="type" name="type" required>
                                        <option value="">Select Type</option>
                                        <option value="announcement" {{ old('type') == 'announcement' ? 'selected' : '' }}>Announcement</option>
                                        <option value="offer" {{ old('type') == 'offer' ? 'selected' : '' }}>Offer</option>
                                        <option value="promotion" {{ old('type') == 'promotion' ? 'selected' : '' }}>Promotion</option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="status">Status <span class="text-danger">*</span></label>
                                    <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                        <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="show_popup" name="show_popup" value="1"
                                               {{ old('show_popup') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_popup">
                                            Show as Popup on User Login
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">If checked, this announcement will appear as a popup when users log in.</small>
                                </div>

                                <div class="form-group">
                                    <label for="start_date">Start Date</label>
                                    <input type="datetime-local" class="form-control @error('start_date') is-invalid @enderror" 
                                           id="start_date" name="start_date" value="{{ old('start_date') }}">
                                    @error('start_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Leave empty to start immediately.</small>
                                </div>

                                <div class="form-group">
                                    <label for="end_date">End Date</label>
                                    <input type="datetime-local" class="form-control @error('end_date') is-invalid @enderror" 
                                           id="end_date" name="end_date" value="{{ old('end_date') }}">
                                    @error('end_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Leave empty for no end date.</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i icon-name="save"></i> Create Announcement
                            </button>
                            <a href="{{ route('admin.announcement.index') }}" class="btn btn-secondary">
                                <i icon-name="x"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('single-script')
<script>
$(document).ready(function() {
    // Preview functionality
    $('#message').on('input', function() {
        // You can add live preview here if needed
    });
    
    // Debug: Log form data
    $('form').on('submit', function(e) {
        console.log('Form submitted');
        console.log('show_popup value:', $('#show_popup').is(':checked'));
        console.log('show_popup name:', $('#show_popup').attr('name'));
    });
});
</script>
@endpush
@endsection
