@extends('backend.layouts.master')

@section('title', 'View Manual Payment Gateway')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Manual Payment Gateway Details</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.manual-payment-gateways.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                        <a href="{{ route('admin.manual-payment-gateways.edit', $manualPaymentGateway) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th width="30%">ID:</th>
                                    <td>{{ $manualPaymentGateway->id }}</td>
                                </tr>
                                <tr>
                                    <th>Name:</th>
                                    <td>{{ $manualPaymentGateway->name }}</td>
                                </tr>
                                <tr>
                                    <th>Code:</th>
                                    <td><span class="badge badge-info">{{ $manualPaymentGateway->code }}</span></td>
                                </tr>
                                <tr>
                                    <th>Network:</th>
                                    <td>{{ $manualPaymentGateway->network ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        @if($manualPaymentGateway->status)
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Sort Order:</th>
                                    <td>{{ $manualPaymentGateway->sort_order }}</td>
                                </tr>
                            </table>
                        </div>
                        
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th width="30%">Currency:</th>
                                    <td>{{ $manualPaymentGateway->currency }}</td>
                                </tr>
                                <tr>
                                    <th>Currency Symbol:</th>
                                    <td>{{ $manualPaymentGateway->currency_symbol }}</td>
                                </tr>
                                <tr>
                                    <th>Min Amount:</th>
                                    <td>{{ $manualPaymentGateway->currency_symbol }}{{ $manualPaymentGateway->minimum_amount }}</td>
                                </tr>
                                <tr>
                                    <th>Max Amount:</th>
                                    <td>{{ $manualPaymentGateway->currency_symbol }}{{ $manualPaymentGateway->maximum_amount }}</td>
                                </tr>
                                <tr>
                                    <th>Fee Percentage:</th>
                                    <td>{{ $manualPaymentGateway->fee_percentage }}%</td>
                                </tr>
                                <tr>
                                    <th>Fixed Fee:</th>
                                    <td>{{ $manualPaymentGateway->currency_symbol }}{{ $manualPaymentGateway->fee_fixed }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5>Wallet Address</h5>
                            <div class="alert alert-info">
                                <code>{{ $manualPaymentGateway->wallet_address }}</code>
                            </div>
                        </div>
                    </div>
                    
                    @if($manualPaymentGateway->qr_code)
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5>QR Code</h5>
                            <div class="text-center">
                                <img src="{{ $manualPaymentGateway->qr_code }}" alt="QR Code" class="img-thumbnail" style="max-width: 200px;">
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    @if($manualPaymentGateway->payment_instructions)
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5>Payment Instructions</h5>
                            <div class="alert alert-light">
                                {{ $manualPaymentGateway->payment_instructions }}
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5>Timestamps</h5>
                            <table class="table table-bordered">
                                <tr>
                                    <th width="30%">Created At:</th>
                                    <td>{{ $manualPaymentGateway->created_at->format('Y-m-d H:i:s') }}</td>
                                </tr>
                                <tr>
                                    <th>Updated At:</th>
                                    <td>{{ $manualPaymentGateway->updated_at->format('Y-m-d H:i:s') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection














