@extends('backend.layouts.app')
@section('title') {{ __('Sliders') }} @endsection
@section('content')
    <div class="main-content">
        <div class="page-title"><div class="container-fluid"><h2 class="title">{{ __('Homepage Sliders') }}</h2></div></div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-4">
                    <div class="site-card">
                        <div class="site-card-header"><h3 class="title">{{ __('Add New Slide') }}</h3></div>
                        <div class="site-card-body">
                            <form action="{{ route('admin.slider.store') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Title') }}</label>
                                    <input type="text" name="title" class="box-input" required>
                                </div>
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Default Image') }}</label>
                                    <div class="wrap-custom-file">
                                        <input type="file" name="image" id="slideImg" accept=".gif,.jpg,.jpeg,.png,.webp" required>
                                        <label for="slideImg">
                                            <img class="upload-icon" src="{{ asset('global/materials/upload.svg') }}" alt=""/>
                                            <span>{{ __('Upload Image') }}</span>
                                        </label>
                                    </div>
                                </div>
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Desktop Image (optional)') }}</label>
                                    <div class="wrap-custom-file">
                                        <input type="file" name="desktop_image" id="slideDesktopImg" accept=".gif,.jpg,.jpeg,.png,.webp">
                                        <label for="slideDesktopImg">
                                            <img class="upload-icon" src="{{ asset('global/materials/upload.svg') }}" alt=""/>
                                            <span>{{ __('Upload Desktop Image') }}</span>
                                        </label>
                                    </div>
                                </div>
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Mobile Image (optional)') }}</label>
                                    <div class="wrap-custom-file">
                                        <input type="file" name="mobile_image" id="slideMobileImg" accept=".gif,.jpg,.jpeg,.png,.webp">
                                        <label for="slideMobileImg">
                                            <img class="upload-icon" src="{{ asset('global/materials/upload.svg') }}" alt=""/>
                                            <span>{{ __('Upload Mobile Image') }}</span>
                                        </label>
                                    </div>
                                </div>
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Optional Link') }}</label>
                                    <input type="url" name="link" class="box-input" placeholder="https://...">
                                </div>
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Position') }}</label>
                                    <input type="number" name="position" class="box-input" value="0">
                                </div>
                                <div class="site-input-groups">
                                    <label class="box-input-label">{{ __('Status') }}</label>
                                    <select name="status" class="form-select">
                                        <option value="1">{{ __('Active') }}</option>
                                        <option value="0">{{ __('Inactive') }}</option>
                                    </select>
                                </div>
                                <button class="site-btn-sm primary-btn w-100" type="submit">{{ __('Add Slide') }}</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-xl-8">
                    <div class="site-card">
                        <div class="site-card-header"><h3 class="title">{{ __('All Slides') }}</h3></div>
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead><tr><th>{{ __('Image') }}</th><th>{{ __('Title') }}</th><th>{{ __('Position') }}</th><th>{{ __('Status') }}</th><th>{{ __('Action') }}</th></tr></thead>
                                    <tbody>
                                    @forelse($sliders as $slide)
                                        <tr>
                                            <td><img class="avatar" src="{{ asset($slide->desktop_image ?: $slide->image) }}" alt=""></td>
                                            <td>{{ $slide->title }}</td>
                                            <td>{{ $slide->position }}</td>
                                            <td>{{ $slide->status ? __('Active') : __('Inactive') }}</td>
                                            <td>
                                                <form action="{{ route('admin.slider.destroy',$slide) }}" method="post" onsubmit="return confirm('Delete this slide?')">
                                                    @csrf @method('DELETE')
                                                    <button class="round-icon-btn red-btn" type="submit"><i icon-name="trash-2"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr><td colspan="5">{{ __('No slides added yet.') }}</td></tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


