@extends('backend.layouts.app')

@section('title', 'Manual Profit Distribution')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Manual Profit Distribution</li>
                    </ol>
                </div>
                <h4 class="page-title">
                    <i class="fas fa-coins text-warning"></i>
                    Manual Profit Distribution
                </h4>
            </div>
        </div>
    </div>

    <!-- Debug Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-warning">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0"><i class="fas fa-bug"></i> Debug Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Test Buttons:</h6>
                            <button type="button" class="btn btn-primary me-2" onclick="testAlert()">
                                <i class="fas fa-bell"></i> Test SweetAlert
                            </button>
                            <button type="button" class="btn btn-success me-2" onclick="testAjax()">
                                <i class="fas fa-sync"></i> Test AJAX
                            </button>
                            <button type="button" class="btn btn-info" onclick="checkConsole()">
                                <i class="fas fa-terminal"></i> Check Console
                            </button>
                        </div>
                        <div class="col-md-6">
                            <h6>Page Status:</h6>
                            <p class="mb-1"><strong>CSRF Token:</strong> <span id="csrfStatus">Checking...</span></p>
                            <p class="mb-1"><strong>SweetAlert2:</strong> <span id="swalStatus">Checking...</span></p>
                            <p class="mb-1"><strong>jQuery:</strong> <span id="jqueryStatus">Checking...</span></p>
                            <p class="mb-1"><strong>Active Investments:</strong> <span id="investmentCount">Checking...</span></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h3 class="text-white">{{ $activeInvestments->count() }}</h3>
                            <p class="mb-0">Active Investments</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-chart-line fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h3 class="text-white">${{ number_format($totalPendingProfit, 2) }}</h3>
                            <p class="mb-0">Total Pending Profit</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-dollar-sign fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h3 class="text-white">{{ $activeInvestments->where('next_profit_time', '<=', now())->count() }}</h3>
                            <p class="mb-0">Due for Profit</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-clock fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h3 class="text-white">{{ $schemas->count() }}</h3>
                            <p class="mb-0">Active Plans</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-cube fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bulk Actions -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-rocket text-success"></i>
                            Bulk Profit Distribution
                        </h5>
                        <div>
                            <button type="button" class="btn btn-outline-primary btn-sm me-2" id="selectAllBtn">
                                <i class="fas fa-check-double"></i> Select All Due
                            </button>
                            <button type="button" class="btn btn-success btn-sm" id="bulkDistributeBtn" disabled>
                                <i class="fas fa-rocket"></i> Distribute Selected (<span id="selectedCount">0</span>)
                            </button>
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Timeline:</strong> Apka profit subah 5 bajay mil jayega
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Investments Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-list text-primary"></i>
                        Active Investment Plans
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="masterCheckbox">
                                        </div>
                                    </th>
                                    <th>User</th>
                                    <th>Plan</th>
                                    <th>Amount</th>
                                    <th>ROI</th>
                                    <th>Profit Due</th>
                                    <th>Progress</th>
                                    <th>Next Profit</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($activeInvestments as $investment)
                                    @php
                                        // Use dynamic ROI calculation instead of static interest
                                        $profitDue = $investment->calculated_profit;
                                        
                                        $totalPeriods = $investment->total_period ?? 1;
                                        $completedPeriods = $investment->already_return_profit ?? 0;
                                        $progressPercentage = $totalPeriods > 0 ? ($completedPeriods / $totalPeriods) * 100 : 0;
                                        
                                        $nextProfitTime = \Carbon\Carbon::parse($investment->next_profit_time);
                                        $isDue = $nextProfitTime <= now();
                                    @endphp
                                    <tr class="{{ $isDue ? 'table-warning' : '' }}">
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input investment-checkbox" type="checkbox" 
                                                       value="{{ $investment->id }}" 
                                                       {{ !$isDue ? 'disabled' : '' }}>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-sm bg-primary rounded-circle me-2">
                                                    <span class="avatar-title text-white">
                                                        {{ strtoupper(substr($investment->user->username ?? 'N/A', 0, 2)) }}
                                                    </span>
                                                </div>
                                                <div>
                                                    <strong>{{ $investment->user->username ?? 'N/A' }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $investment->user->email ?? 'N/A' }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <strong class="text-primary">{{ $investment->schema->name ?? 'N/A' }}</strong>
                                                <br>
                                                <small class="text-muted">{{ $investment->schema->description ?? 'No description' }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            <strong class="text-success">${{ number_format($investment->invest_amount, 2) }}</strong>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                {{ $investment->dynamic_interest }}{{ $investment->dynamic_interest_type == 'percentage' ? '%' : '' }}
                                            </span>
                                        </td>
                                        <td>
                                            <strong class="text-warning">${{ number_format($profitDue, 2) }}</strong>
                                        </td>
                                        <td>
                                            <div class="mb-2">
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-{{ $progressPercentage >= 100 ? 'success' : 'primary' }}" 
                                                         style="width: {{ min($progressPercentage, 100) }}%"></div>
                                                </div>
                                            </div>
                                            <small class="text-muted">
                                                {{ number_format($progressPercentage, 1) }}% Complete
                                                <br>
                                                @if($progressPercentage >= 100)
                                                    <span class="text-success">✅ Plan Completed</span>
                                                @else
                                                    {{ ($totalPeriods - $completedPeriods) }} Times Remaining
                                                @endif
                                            </small>
                                        </td>
                                        <td>
                                            @if($isDue)
                                                <span class="badge bg-danger">Due Now</span>
                                            @else
                                                <small class="text-muted">
                                                    {{ $nextProfitTime->diffForHumans() }}
                                                </small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($isDue)
                                                <button type="button" class="btn btn-sm btn-success distribute-single" 
                                                        data-investment="{{ $investment->id }}"
                                                        data-profit="{{ $profitDue }}"
                                                        data-user="{{ $investment->user->username ?? 'N/A' }}">
                                                    <i class="fas fa-coins"></i> Distribute
                                                </button>
                                            @else
                                                <button type="button" class="btn btn-sm btn-secondary" disabled>
                                                    <i class="fas fa-clock"></i> Wait
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                                <h5>No Active Investments Found</h5>
                                                <p>All investments are either completed or not due for profit distribution.</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Distribution Modal -->
<div class="modal fade" id="distributionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-coins text-warning"></i>
                    Distribute Profit
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="distributionForm">
                    <input type="hidden" id="investmentId" name="investment_id">
                    
                    <div class="mb-3">
                        <label class="form-label">User</label>
                        <input type="text" class="form-control" id="userName" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Profit Amount</label>
                        <div class="input-group">
                            <span class="input-group-text">$</span>
                            <input type="number" class="form-control" id="profitAmount" name="profit_amount" 
                                   step="0.01" min="0.01" required>
                        </div>
                        <small class="text-muted">This amount will be added to user's profit balance</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes (Optional)</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3" 
                                  placeholder="Add any notes about this distribution..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="confirmDistribution">
                    <i class="fas fa-check"></i> Confirm Distribution
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('single-script')
<script>
$(document).ready(function() {
    console.log('=== MANUAL DISTRIBUTION PAGE DEBUG ===');
    console.log('Page loaded at:', new Date().toISOString());
    
    // Check dependencies
    checkDependencies();
    
    let selectedInvestments = [];
    
    // Master checkbox
    $('#masterCheckbox').change(function() {
        console.log('Master checkbox changed:', this.checked);
        $('.investment-checkbox:not(:disabled)').prop('checked', this.checked);
        updateBulkButton();
    });
    
    // Individual checkboxes
    $(document).on('change', '.investment-checkbox', function() {
        console.log('Individual checkbox changed:', $(this).val(), 'checked:', this.checked);
        updateBulkButton();
        updateMasterCheckbox();
    });
    
    // Select all due investments
    $('#selectAllBtn').click(function() {
        console.log('Select all button clicked');
        $('.investment-checkbox:not(:disabled)').prop('checked', true);
        updateBulkButton();
        updateMasterCheckbox();
    });
    
    // Update bulk button state
    function updateBulkButton() {
        selectedInvestments = $('.investment-checkbox:checked').map(function() {
            return $(this).val();
        }).get();
        
        console.log('Selected investments:', selectedInvestments);
        $('#bulkDistributeBtn').prop('disabled', selectedInvestments.length === 0);
        $('#selectedCount').text(selectedInvestments.length);
    }
    
    // Update master checkbox
    function updateMasterCheckbox() {
        let totalCheckboxes = $('.investment-checkbox:not(:disabled)').length;
        let checkedCheckboxes = $('.investment-checkbox:checked').length;
        
        console.log('Checkbox state - Total:', totalCheckboxes, 'Checked:', checkedCheckboxes);
        
        if (checkedCheckboxes === 0) {
            $('#masterCheckbox').prop('indeterminate', false).prop('checked', false);
        } else if (checkedCheckboxes === totalCheckboxes) {
            $('#masterCheckbox').prop('indeterminate', false).prop('checked', true);
        } else {
            $('#masterCheckbox').prop('indeterminate', true);
        }
    }
    
    // Single distribution
    $(document).on('click', '.distribute-single', function() {
        console.log('=== SINGLE DISTRIBUTE BUTTON CLICKED ===');
        let investmentId = $(this).data('investment');
        let profitAmount = $(this).data('profit');
        let userName = $(this).data('user');
        
        console.log('Investment ID:', investmentId);
        console.log('Profit Amount:', profitAmount);
        console.log('User Name:', userName);
        console.log('Button element:', this);
        
        $('#investmentId').val(investmentId);
        $('#userName').val(userName);
        $('#profitAmount').val(profitAmount);
        
        console.log('Modal data set - Opening modal...');
        $('#distributionModal').modal('show');
    });
    
    // Confirm single distribution
    $('#confirmDistribution').click(function() {
        console.log('=== CONFIRM DISTRIBUTION CLICKED ===');
        let formData = $('#distributionForm').serialize();
        let csrfToken = $('meta[name="csrf-token"]').attr('content');
        
        console.log('Form data:', formData);
        console.log('CSRF token:', csrfToken);
        console.log('Form element:', $('#distributionForm')[0]);
        
        if (!csrfToken) {
            console.error('CSRF token not found!');
            alert('CSRF token missing. Please refresh the page.');
            return;
        }
        
        $.ajax({
            url: '{{ route("admin.profit-distribution.distribute") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': csrfToken
            },
            beforeSend: function() {
                console.log('AJAX request starting...');
                $('#confirmDistribution').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');
            },
            success: function(response) {
                console.log('=== AJAX SUCCESS ===');
                console.log('Response:', response);
                
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response.message
                    });
                }
            },
            error: function(xhr, status, error) {
                console.log('=== AJAX ERROR ===');
                console.log('Status:', status);
                console.log('Error:', error);
                console.log('Response Text:', xhr.responseText);
                console.log('Status Code:', xhr.status);
                
                let errorMessage = 'Something went wrong. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: errorMessage
                });
            },
            complete: function() {
                console.log('AJAX request completed');
                $('#confirmDistribution').prop('disabled', false).html('<i class="fas fa-check"></i> Confirm Distribution');
            }
        });
    });
    
    // Bulk distribution
    $('#bulkDistributeBtn').click(function() {
        console.log('=== BULK DISTRIBUTE BUTTON CLICKED ===');
        console.log('Selected investments for bulk:', selectedInvestments);
        
        if (selectedInvestments.length === 0) {
            console.log('No investments selected for bulk distribution');
            return;
        }
        
        Swal.fire({
            title: 'Confirm Bulk Distribution',
            text: `Are you sure you want to distribute profit to ${selectedInvestments.length} investments?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Distribute!'
        }).then((result) => {
            if (result.isConfirmed) {
                console.log('Bulk distribution confirmed, starting AJAX...');
                
                $.ajax({
                    url: '{{ route("admin.profit-distribution.bulk") }}',
                    method: 'POST',
                    data: {
                        investment_ids: selectedInvestments,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    beforeSend: function() {
                        console.log('Bulk AJAX request starting...');
                        $('#bulkDistributeBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');
                    },
                    success: function(response) {
                        console.log('=== BULK AJAX SUCCESS ===');
                        console.log('Response:', response);
                        
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Success!',
                                text: response.message,
                                html: `
                                    <div class="text-left">
                                        <p><strong>Distributed:</strong> ${response.data.distributed_count} investments</p>
                                        <p><strong>Total Profit:</strong> $${response.data.total_profit}</p>
                                        ${response.data.errors.length > 0 ? '<p><strong>Errors:</strong></p><ul>' + response.data.errors.map(e => '<li>' + e + '</li>').join('') + '</ul>' : ''}
                                    </div>
                                `
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('=== BULK AJAX ERROR ===');
                        console.log('Status:', status);
                        console.log('Error:', error);
                        console.log('Response Text:', xhr.responseText);
                        console.log('Status Code:', xhr.status);
                        
                        let errorMessage = 'Bulk distribution failed. Please try again.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: errorMessage
                        });
                    },
                    complete: function() {
                        console.log('Bulk AJAX request completed');
                        $('#bulkDistributeBtn').prop('disabled', false).html('<i class="fas fa-rocket"></i> Distribute Selected (<span id="selectedCount">' + selectedInvestments.length + '</span>)');
                    }
                });
            }
        });
    });
    
    // Check dependencies
    function checkDependencies() {
        console.log('Checking dependencies...');
        
        // Check CSRF token
        let csrfToken = $('meta[name="csrf-token"]').attr('content');
        if (csrfToken) {
            console.log('✓ CSRF token found:', csrfToken.substring(0, 20) + '...');
            $('#csrfStatus').html('<span class="text-success">✓ Found</span>');
        } else {
            console.error('✗ CSRF token not found');
            $('#csrfStatus').html('<span class="text-danger">✗ Missing</span>');
        }
        
        // Check SweetAlert2
        if (typeof Swal !== 'undefined') {
            console.log('✓ SweetAlert2 loaded');
            $('#swalStatus').html('<span class="text-success">✓ Loaded</span>');
        } else {
            console.error('✗ SweetAlert2 not loaded');
            $('#swalStatus').html('<span class="text-danger">✗ Not Loaded</span>');
        }
        
        // Check jQuery
        if (typeof $ !== 'undefined') {
            console.log('✓ jQuery loaded');
            $('#jqueryStatus').html('<span class="text-success">✓ Loaded</span>');
        } else {
            console.error('✗ jQuery not loaded');
            $('#jqueryStatus').html('<span class="text-danger">✗ Not Loaded</span>');
        }
        
        // Check investments count
        let investmentCount = $('.investment-checkbox').length;
        console.log('✓ Active investments found:', investmentCount);
        $('#investmentCount').html('<span class="text-success">' + investmentCount + '</span>');
        
        // Check due investments
        let dueInvestments = $('.investment-checkbox:not(:disabled)').length;
        console.log('✓ Due investments:', dueInvestments);
    }
    
    // Initialize
    updateBulkButton();
    updateMasterCheckbox();
    console.log('=== MANUAL DISTRIBUTION PAGE INITIALIZED ===');
});

// Test functions
function testAlert() {
    console.log('Testing SweetAlert...');
    if (typeof Swal !== 'undefined') {
        Swal.fire({
            title: 'Test Alert',
            text: 'SweetAlert2 is working!',
            icon: 'success'
        });
    } else {
        alert('SweetAlert2 is not loaded!');
    }
}

function testAjax() {
    console.log('Testing AJAX...');
    $.ajax({
        url: '{{ route("admin.dashboard") }}',
        method: 'GET',
        success: function(response) {
            console.log('AJAX test successful');
            alert('AJAX is working!');
        },
        error: function(xhr, status, error) {
            console.log('AJAX test failed:', error);
            alert('AJAX test failed: ' + error);
        }
    });
}

function checkConsole() {
    console.log('=== CONSOLE CHECK ===');
    console.log('Current time:', new Date().toISOString());
    console.log('Page URL:', window.location.href);
    console.log('User agent:', navigator.userAgent);
    console.log('jQuery version:', $.fn.jquery);
    console.log('Bootstrap version:', typeof bootstrap !== 'undefined' ? 'Loaded' : 'Not loaded');
    console.log('SweetAlert2 version:', typeof Swal !== 'undefined' ? 'Loaded' : 'Not loaded');
    
    alert('Check browser console for detailed information!');
}
</script>
@endpush

@push('styles')
<style>
.progress {
    border-radius: 10px;
}

.progress-bar {
    border-radius: 10px;
}

.avatar-sm {
    width: 32px;
    height: 32px;
}

.avatar-title {
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 14px;
}

.table-warning {
    background-color: rgba(255, 193, 7, 0.1) !important;
}

.badge {
    font-size: 11px;
    padding: 5px 8px;
}

.card.border-warning {
    border: 2px solid #ffc107 !important;
}
</style>
@endpush
