@extends('backend.layouts.app')

@section('title', 'User ROI Details - ' . $user->full_name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">
                        <i class="fas fa-user"></i> {{ $user->full_name }} - ROI Details
                    </h4>
                    <div class="card-tools">
                        <a href="{{ route('admin.roi-tracking.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- User Info -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info">
                                    <img src="{{ asset($user->avatar) }}" class="rounded-circle" width="50" height="50">
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">User</span>
                                    <span class="info-box-number">{{ $user->full_name }}</span>
                                    <small class="text-muted">{{ $user->email }}</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success">
                                    <i class="fas fa-wallet"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Main Balance</span>
                                    <span class="info-box-number">${{ number_format($user->balance, 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning">
                                    <i class="fas fa-chart-line"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Profit Balance</span>
                                    <span class="info-box-number">${{ number_format($user->profit_balance, 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary">
                                    <i class="fas fa-chart-pie"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total ROI Earned</span>
                                    <span class="info-box-number">${{ number_format($roiHistory->sum('amount'), 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Today's ROI Section -->
                    @if($todayRoi->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card card-success">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-clock"></i> Today's ROI Due
                                    </h5>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-success btn-sm" onclick="processTodayRoi()">
                                            <i class="fas fa-play"></i> Process All Today's ROI
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Plan Name</th>
                                                    <th>Investment Amount</th>
                                                    <th>ROI Amount</th>
                                                    <th>Progress</th>
                                                    <th>Next ROI Time</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($todayRoi as $roi)
                                                <tr>
                                                    <td>
                                                        <strong>{{ $roi['invest']->schema->name }}</strong><br>
                                                        <small class="text-muted">{{ $roi['invest']->schema->description }}</small>
                                                    </td>
                                                    <td>${{ number_format($roi['invest']->invest_amount, 2) }}</td>
                                                    <td>
                                                        <span class="text-success font-weight-bold">
                                                            ${{ number_format($roi['roi_amount'], 2) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="progress" style="height: 20px;">
                                                            <div class="progress-bar bg-success" style="width: {{ $roi['progress'] }}%">
                                                                {{ number_format($roi['progress'], 1) }}%
                                                            </div>
                                                        </div>
                                                        <small class="text-muted">
                                                            {{ $roi['invest']->already_return_profit }}/{{ $roi['invest']->number_of_period }}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <small>{{ \Carbon\Carbon::parse($roi['invest']->next_profit_time)->format('M d, Y H:i') }}</small><br>
                                                        <small class="text-muted">{{ \Carbon\Carbon::parse($roi['invest']->next_profit_time)->diffForHumans() }}</small>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-success btn-sm" 
                                                                onclick="processSingleRoi({{ $roi['invest']->id }})">
                                                            <i class="fas fa-play"></i> Process
                                                        </button>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Upcoming ROI Section -->
                    @if($upcomingRoi->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-calendar"></i> Upcoming ROI
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Plan Name</th>
                                                    <th>Investment Amount</th>
                                                    <th>ROI Amount</th>
                                                    <th>Progress</th>
                                                    <th>Next ROI Time</th>
                                                    <th>Time Until ROI</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($upcomingRoi as $roi)
                                                <tr>
                                                    <td>
                                                        <strong>{{ $roi['invest']->schema->name }}</strong><br>
                                                        <small class="text-muted">{{ $roi['invest']->schema->description }}</small>
                                                    </td>
                                                    <td>${{ number_format($roi['invest']->invest_amount, 2) }}</td>
                                                    <td>
                                                        <span class="text-info font-weight-bold">
                                                            ${{ number_format($roi['roi_amount'], 2) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="progress" style="height: 20px;">
                                                            <div class="progress-bar bg-info" style="width: {{ $roi['progress'] }}%">
                                                                {{ number_format($roi['progress'], 1) }}%
                                                            </div>
                                                        </div>
                                                        <small class="text-muted">
                                                            {{ $roi['invest']->already_return_profit }}/{{ $roi['invest']->number_of_period }}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <small>{{ \Carbon\Carbon::parse($roi['invest']->next_profit_time)->format('M d, Y H:i') }}</small>
                                                    </td>
                                                    <td>
                                                        <span class="text-info">{{ $roi['time_until_roi'] }}</span>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Investment History -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-history"></i> Investment History
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Plan Name</th>
                                                    <th>Investment Amount</th>
                                                    <th>Status</th>
                                                    <th>Start Date</th>
                                                    <th>Progress</th>
                                                    <th>Total ROI Earned</th>
                                                    <th>Last ROI</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($investments as $investment)
                                                <tr>
                                                    <td>
                                                        <strong>{{ $investment->schema->name }}</strong><br>
                                                        <small class="text-muted">{{ $investment->schema->description }}</small>
                                                    </td>
                                                    <td>${{ number_format($investment->invest_amount, 2) }}</td>
                                                    <td>
                                                                                                            @if($investment->status == \App\Enums\InvestStatus::Ongoing)
                                                        <span class="badge badge-success">Active</span>
                                                    @elseif($investment->status == \App\Enums\InvestStatus::Completed)
                                                        <span class="badge badge-info">Completed</span>
                                                        @else
                                                            <span class="badge badge-warning">{{ ucfirst($investment->status->value) }}</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ \Carbon\Carbon::parse($investment->created_at)->format('M d, Y H:i') }}</td>
                                                    <td>
                                                        @php
                                                            $progress = $investment->return_type == 'lifetime' 
                                                                ? 100 
                                                                : min(100, ($investment->already_return_profit / $investment->number_of_period) * 100);
                                                        @endphp
                                                        <div class="progress" style="height: 20px;">
                                                            <div class="progress-bar bg-primary" style="width: {{ $progress }}%">
                                                                {{ number_format($progress, 1) }}%
                                                            </div>
                                                        </div>
                                                        <small class="text-muted">
                                                            {{ $investment->already_return_profit }}/{{ $investment->number_of_period }}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <span class="font-weight-bold">${{ number_format($investment->total_profit_amount, 2) }}</span>
                                                    </td>
                                                    <td>
                                                        @if($investment->last_profit_time)
                                                            <small>{{ \Carbon\Carbon::parse($investment->last_profit_time)->format('M d, Y H:i') }}</small><br>
                                                            <small class="text-muted">{{ \Carbon\Carbon::parse($investment->last_profit_time)->diffForHumans() }}</small>
                                                        @else
                                                            <span class="text-muted">Not yet</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="7" class="text-center">No investments found</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ROI History -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-chart-line"></i> ROI History
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Plan</th>
                                                    <th>ROI Amount</th>
                                                    <th>Transaction ID</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($roiHistory as $roi)
                                                <tr>
                                                    <td>
                                                        <small>{{ \Carbon\Carbon::parse($roi->created_at)->format('M d, Y H:i') }}</small><br>
                                                        <small class="text-muted">{{ \Carbon\Carbon::parse($roi->created_at)->diffForHumans() }}</small>
                                                    </td>
                                                    <td>{{ $roi->description }}</td>
                                                    <td>
                                                        <span class="text-success font-weight-bold">
                                                            ${{ number_format($roi->amount, 2) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <code>{{ $roi->tnx }}</code>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="4" class="text-center">No ROI history found</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
function processTodayRoi() {
    Swal.fire({
        title: 'Process Today\'s ROI',
        text: 'This will process all ROI due today for this user. Continue?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Process All',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Processing...',
                text: 'Please wait',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            fetch('/admin/roi-tracking/process-roi', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    user_id: {{ $user->id }}
                })
            })
            .then(response => response.json())
            .then(data => {
                Swal.close();
                
                if (data.success) {
                    Swal.fire('Success', data.message, 'success').then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Error', data.message || 'Failed to process ROI', 'error');
                }
            })
            .catch(error => {
                Swal.close();
                Swal.fire('Error', 'Failed to process ROI', 'error');
            });
        }
    });
}

function processSingleRoi(investId) {
    Swal.fire({
        title: 'Process ROI',
        text: 'Are you sure you want to process this ROI?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Process',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Processing...',
                text: 'Please wait',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            fetch('/admin/roi-tracking/process-single-roi', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    invest_id: investId
                })
            })
            .then(response => response.json())
            .then(data => {
                Swal.close();
                
                if (data.success) {
                    Swal.fire('Success', data.message, 'success').then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Error', data.message || 'Failed to process ROI', 'error');
                }
            })
            .catch(error => {
                Swal.close();
                Swal.fire('Error', 'Failed to process ROI', 'error');
            });
        }
    });
}
</script>
@endpush
