@extends('backend.layouts.app')
@section('title')
    {{ __('Manage Schema') }}
@endsection
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function(){
    const tbody = document.querySelector('#schema-table tbody');
    if (!tbody) return;
    let dragging = null; let placeholder = null; let startY = 0;
    tbody.addEventListener('mousedown', function(e){
        const handle = e.target.closest('.drag-handle');
        if (!handle) return;
        dragging = handle.parentElement;
        startY = e.clientY;
        placeholder = document.createElement('tr');
        placeholder.innerHTML = '<td colspan="7" style="height:12px;border:1px dashed #999"></td>';
        dragging.parentNode.insertBefore(placeholder, dragging.nextSibling);
        dragging.classList.add('dragging');
        document.addEventListener('mousemove', onMove);
        document.addEventListener('mouseup', onUp);
    });
    function onMove(e){
        const y = e.clientY;
        const delta = y - startY;
        dragging.style.transform = `translateY(${delta}px)`;
        const prev = placeholder.previousElementSibling;
        const next = placeholder.nextElementSibling;
        if (prev && y < prev.getBoundingClientRect().top + prev.offsetHeight/2){
            tbody.insertBefore(placeholder, prev);
        }
        if (next && y > next.getBoundingClientRect().top + next.offsetHeight/2){
            tbody.insertBefore(next, placeholder);
        }
    }
    function onUp(){
        dragging.style.transform = '';
        tbody.insertBefore(dragging, placeholder);
        placeholder.remove();
        dragging.classList.remove('dragging');
        document.removeEventListener('mousemove', onMove);
        document.removeEventListener('mouseup', onUp);
    }

    document.getElementById('save-order').addEventListener('click', function(){
        const order = Array.from(tbody.querySelectorAll('tr[data-id]')).map((row, idx)=>({id: row.dataset.id, order: idx+1}));
        fetch('{{ route('admin.schema.reorder') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ order })
        }).then(async (r)=>{
            const contentType = r.headers.get('content-type') || '';
            if (!r.ok) {
                if (contentType.includes('application/json')) {
                    const data = await r.json();
                    throw new Error(data.message || ('Error '+r.status));
                } else {
                    const text = await r.text();
                    throw new Error((text && text.slice(0,200)) || ('Error '+r.status));
                }
            }
            if (contentType.includes('application/json')) {
                return r.json();
            } else {
                return { message: 'Order saved' };
            }
        }).then(d=>{ alert(d.message || 'Order saved'); }).catch(err=>{
            console.error('Save order failed:', err);
            alert('Save failed: '+ err.message);
        });
    });
});
</script>
@endpush
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title">{{ __('All Plans') }}</h2>
                            @can('schema-create')
                                <a href="{{route('admin.schema.create')}}" class="title-btn"><i
                                        icon-name="plus-circle"></i>{{ __('Add New') }}</a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table" id="schema-table">
                                    <thead>
                                    <tr>
                                        <th style="width:40px">#</th>
                                        <th scope="col">{{ __('Icon') }}</th>
                                        <th scope="col">{{ __('Plan Name') }}</th>
                                        <th scope="col">{{ __('Amount') }}</th>
                                        <th scope="col">{{ __('Badge') }}</th>
                                        <th scope="col">{{ __('Status') }}</th>
                                        <th scope="col">{{ __('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($schemas->sortBy('display_order') as $schema)
                                        <tr data-id="{{$schema->id}}" class="draggable-row">
                                            <td class="drag-handle" style="cursor:grab">⋮⋮</td>
                                            <td>
                                                <img
                                                    class="avatar"
                                                    src="{{ asset($schema->icon) }}"
                                                    alt=""
                                                />
                                            </td>
                                            <td><strong>{{$schema->name}}</strong></td>
                                            <td>
                                                <strong>{{ $schema->type == 'range'? $schema->min_amount.' '.$currency.'-'.$schema->max_amount.' '.$currency:$schema->fixed_amount.' '.$currency }}</strong>
                                            </td>
                                            <td>
                                                <div @class([
                                                    'site-badge', // common classes
                                                    'success' => $schema->featured,
                                                    'pending' => !$schema->featured
                                                  ])>{{ $schema->featured ? $schema->badge : 'No Feature Badge' }}</div>
                                            </td>
                                            <td>
                                                <div @class([
                                                    'site-badge', // common classes
                                                    'success' => $schema->status,
                                                    'danger' => !$schema->status
                                                  ])>{{ $schema->status ? 'Active' : 'Deactivated' }}</div>
                                            </td>
                                            <td>
                                                @can('schema-edit')
                                                    <a href="{{route('admin.schema.edit',$schema->id)}}"
                                                       class="round-icon-btn primary-btn">
                                                        <i icon-name="edit-3"></i>
                                                    </a>
                                                @endcan

                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <div class="mt-2 text-end">
                                    <button id="save-order" class="site-btn primary-btn btn-sm">{{ __('Save Order') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
