@extends('backend.layouts.app')

@section('title')
    User Wallet Details - {{ $user->username }}
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-wallet"></i> Wallet Details - {{ $user->username }}
                        </h3>
                        <div class="card-tools">
                            <a href="{{ route('admin.wallet.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to Wallet Management
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- User Info -->
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <div class="card bg-success text-white">
                                    <div class="card-body text-center">
                                        <h4>${{ number_format($user->balance, 2) }}</h4>
                                        <p class="mb-0">Main Wallet</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-info text-white">
                                    <div class="card-body text-center">
                                        <h4>${{ number_format($user->profit_balance, 2) }}</h4>
                                        <p class="mb-0">Profit Wallet</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-primary text-white">
                                    <div class="card-body text-center">
                                        <h4>${{ number_format($user->balance + $user->profit_balance, 2) }}</h4>
                                        <p class="mb-0">Total Balance</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-warning text-white">
                                    <div class="card-body text-center">
                                        <button type="button" class="btn btn-warning btn-lg" data-bs-toggle="modal" data-bs-target="#manageWalletModal">
                                            <i class="fas fa-edit"></i> Manage Wallet
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- User Details -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h6>User Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>Username:</strong> {{ $user->username }}</p>
                                        <p><strong>Name:</strong> {{ $user->first_name }} {{ $user->last_name }}</p>
                                        <p><strong>Email:</strong> {{ $user->email }}</p>
                                        <p><strong>Phone:</strong> {{ $user->phone ?? 'Not provided' }}</p>
                                        <p><strong>Status:</strong> 
                                            <span class="badge badge-{{ $user->status ? 'success' : 'danger' }}">
                                                {{ $user->status ? 'Active' : 'Inactive' }}
                                            </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h6>Account Statistics</h6>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>Member Since:</strong> {{ $user->created_at->format('M d, Y') }}</p>
                                        <p><strong>Last Login:</strong> {{ $user->last_login_at ? \Carbon\Carbon::parse($user->last_login_at)->format('M d, Y H:i') : 'Never' }}</p>
                                        <p><strong>Total Deposits:</strong> ${{ number_format($user->totalDeposits(), 2) }}</p>
                                        <p><strong>Total Withdrawals:</strong> ${{ number_format($user->totalWithdrawals(), 2) }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Transaction History -->
                        <div class="card">
                            <div class="card-header">
                                <h6>Recent Transactions</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Type</th>
                                                <th>Amount</th>
                                                <th>Status</th>
                                                <th>Description</th>
                                                <th>Transaction ID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($transactions as $transaction)
                                                <tr>
                                                    <td>{{ \Carbon\Carbon::parse($transaction->created_at)->format('M d, Y H:i') }}</td>
                                                    <td>
                                                        <span class="badge badge-{{ $transaction->type->value === 'deposit' ? 'success' : ($transaction->type->value === 'withdraw' ? 'danger' : 'info') }}">
                                                            {{ ucfirst($transaction->type->value) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="{{ $transaction->type->value === 'withdraw' ? 'text-danger' : 'text-success' }}">
                                                            {{ $transaction->type->value === 'withdraw' ? '-' : '+' }}${{ number_format($transaction->amount, 2) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-{{ $transaction->status->value === 'success' ? 'success' : ($transaction->status->value === 'pending' ? 'warning' : 'danger') }}">
                                                            {{ ucfirst($transaction->status->value) }}
                                                        </span>
                                                    </td>
                                                    <td>{{ $transaction->description }}</td>
                                                    <td>
                                                        <code>{{ $transaction->tnx }}</code>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="6" class="text-center">No transactions found</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Manage Wallet Modal -->
    <div class="modal fade" id="manageWalletModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Manage Wallet - {{ $user->username }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h6>Current Balances</h6>
                                </div>
                                <div class="card-body">
                                    <p><strong>Main Wallet:</strong> ${{ number_format($user->balance, 2) }}</p>
                                    <p><strong>Profit Wallet:</strong> ${{ number_format($user->profit_balance, 2) }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h6>Update Balance</h6>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="{{ route('admin.wallet.update-balance') }}">
                                        @csrf
                                        <input type="hidden" name="user_id" value="{{ $user->id }}">
                                        
                                        <div class="form-group">
                                            <label>Wallet Type</label>
                                            <select name="wallet_type" class="form-control" required>
                                                <option value="main">Main Wallet</option>
                                                <option value="profit">Profit Wallet</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Action</label>
                                            <select name="action" class="form-control" required>
                                                <option value="increase">Increase Balance</option>
                                                <option value="decrease">Decrease Balance</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" name="amount" class="form-control" step="0.01" min="0.01" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Reason</label>
                                            <textarea name="reason" class="form-control" rows="2" required placeholder="Enter reason for this action..."></textarea>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Update Balance
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="card">
                        <div class="card-header">
                            <h6>Transfer Between Wallets</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('admin.wallet.transfer-wallet') }}">
                                @csrf
                                <input type="hidden" name="user_id" value="{{ $user->id }}">
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>From Wallet</label>
                                            <select name="from_wallet" class="form-control" required>
                                                <option value="main">Main Wallet</option>
                                                <option value="profit">Profit Wallet</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>To Wallet</label>
                                            <select name="to_wallet" class="form-control" required>
                                                <option value="profit">Profit Wallet</option>
                                                <option value="main">Main Wallet</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="number" name="amount" class="form-control" step="0.01" min="0.01" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label>Reason</label>
                                    <textarea name="reason" class="form-control" rows="2" required placeholder="Enter reason for transfer..."></textarea>
                                </div>
                                
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-exchange-alt"></i> Transfer
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
// Auto-refresh disabled to prevent reload loops in admin screens
</script>
@endpush
erve















