<h3 class="title mb-4">
    {{ __('Withdraw Approval Action') }}
</h3>

<ul class="list-group mb-4">
    <li class="list-group-item">
        {{ __('Withdraw Amount') }}: <strong>{{ $data->amount .' '. $currency }}</strong>
    </li>
    <li class="list-group-item">
        {{ __('Pay Amount') }}: <strong>{{ $data->pay_amount .' '. $data->pay_currency }}</strong>
    </li>
</ul>

<ul class="list-group mb-4">
    @php
        // Check both manual_field_data and details fields
        $manualData = json_decode($data->manual_field_data, true);
        $detailsData = json_decode($data->details, true);
        $isSimpleWithdraw = str_contains($data->method ?? '', 'SIMPLE-');
        
        // Use details data if manual_field_data is null
        if (!$manualData && $detailsData) {
            $manualData = $detailsData;
        }
        
        // Debug: Enable to see actual data
        if(false) {
            echo "<div style='background: #f0f0f0; padding: 10px; margin: 10px 0; border: 1px solid #ccc;'>";
            echo "<h4>DEBUG: Raw Data</h4>";
            echo "<pre>Method: " . ($data->method ?? 'null') . "</pre>";
            echo "<pre>Manual Field Data (raw): " . htmlspecialchars($data->manual_field_data ?? 'null') . "</pre>";
            echo "<pre>Details Data (raw): " . htmlspecialchars($data->details ?? 'null') . "</pre>";
            echo "<pre>Manual Field Data (decoded): " . print_r($manualData, true) . "</pre>";
            echo "<pre>Is Simple Withdraw: " . ($isSimpleWithdraw ? 'true' : 'false') . "</pre>";
            echo "</div>";
        }
    @endphp
    
    @if($isSimpleWithdraw)
        {{-- Enhanced display for Simple Withdraw System --}}
        <li class="list-group-item bg-success text-white text-center">
            <strong>🚀 {{ __('Simple Withdraw Method') }}: {{ str_replace('SIMPLE-', '', $data->method ?? '') }}</strong>
        </li>
        
        @if($manualData && is_array($manualData))
            {{-- Method Type and Selected Method --}}
            @if(isset($manualData['method_type']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Method Type:</strong>
                    <span class="badge bg-primary fs-6">
                        @if($manualData['method_type'] == 'crypto')
                            🚀 Cryptocurrency
                        @else
                            🏦 Banking Services
                        @endif
                    </span>
                </li>
            @endif
            
            @if(isset($manualData['crypto_method']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Crypto Method:</strong>
                    <span class="badge bg-success fs-6">💰 {{ ucfirst($manualData['crypto_method']) }}</span>
                </li>
            @endif
            
            @if(isset($manualData['banking_method']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Banking Method:</strong>
                    <span class="badge bg-info fs-6">🏦 {{ ucfirst($manualData['banking_method']) }}</span>
                </li>
            @endif
            
            @if(isset($manualData['wallet']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Selected Wallet:</strong>
                    <span class="badge bg-warning text-dark fs-6">
                        @if($manualData['wallet'] == 'main')
                            💳 Main Wallet
                        @else
                            📈 Profit Wallet
                        @endif
                    </span>
                </li>
            @endif
            
            {{-- Crypto Details --}}
            @if(isset($manualData['wallet_address']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Wallet Address:</strong>
                    <span class="badge bg-primary fs-6">🔗 {{ $manualData['wallet_address'] }}</span>
                </li>
            @endif
            
            @if(isset($manualData['network_type']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Network Type:</strong>
                    <span class="badge bg-secondary fs-6">🌐 {{ ucfirst($manualData['network_type']) }}</span>
                </li>
            @endif
            
            {{-- Banking Details --}}
            @if(isset($manualData['account_title']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Account Title:</strong>
                    <span class="badge bg-success fs-6">👤 {{ $manualData['account_title'] }}</span>
                </li>
            @endif
            
            @if(isset($manualData['account_number']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Account Number:</strong>
                    <span class="badge bg-info fs-6">📱 {{ $manualData['account_number'] }}</span>
                </li>
            @endif
            
            @if(isset($manualData['bank_name']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Bank Name:</strong>
                    <span class="badge bg-dark fs-6">🏛️ {{ $manualData['bank_name'] }}</span>
                </li>
            @endif
            
            @if(isset($manualData['branch_code']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Branch Code:</strong>
                    <span class="badge bg-warning text-dark fs-6">🏦 {{ $manualData['branch_code'] }}</span>
                </li>
            @endif
            
            {{-- Mobile Payment Details --}}
            @if(isset($manualData['mobile_number']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Mobile Number:</strong>
                    <span class="badge bg-primary fs-6">📱 {{ $manualData['mobile_number'] }}</span>
                </li>
            @endif
            
            @if(isset($manualData['account_name']))
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Account Name:</strong>
                    <span class="badge bg-success fs-6">👤 {{ $manualData['account_name'] }}</span>
                </li>
            @endif
            
            {{-- Other Fields --}}
            @foreach($manualData as $fieldName => $fieldValue)
                @if(!in_array($fieldName, ['method_type', 'crypto_method', 'banking_method', 'wallet', 'wallet_address', 'network_type', 'account_title', 'account_number', 'bank_name', 'branch_code', 'mobile_number', 'account_name']))
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <strong>{{ ucfirst(str_replace('_', ' ', $fieldName)) }}:</strong>
                        <span class="badge bg-secondary fs-6">{{ $fieldValue }}</span>
                    </li>
                @endif
            @endforeach
        @else
            <li class="list-group-item">
                <span class="text-muted">{{ __('No account details provided') }}</span>
            </li>
        @endif
    @else
        {{-- Original format for complex/manual withdraws --}}
        @if($manualData && is_array($manualData))
            @foreach($manualData as $name => $fieldData)
                <li class="list-group-item">
                    {{ $name }}: 
                    @if(is_array($fieldData) && isset($fieldData['type']) && $fieldData['type'] == 'file')
                        <img src="{{ asset(data_get($fieldData, 'value')) }}" alt="{{ $name }}" style="max-width: 200px;"/>
                    @elseif(is_array($fieldData))
                        <strong>{{ data_get($fieldData, 'value') }}</strong>
                    @else
                        <strong>{{ $fieldData }}</strong>
                    @endif
                </li>
            @endforeach
        @else
            <li class="list-group-item">
                <span class="text-muted">{{ __('No withdrawal details available') }}</span>
            </li>
        @endif
    @endif
</ul>

<form action="{{ route('admin.withdraw.action.now') }}" method="post">
    @csrf
    <input type="hidden" name="id" value="{{ $id }}">

    <div class="site-input-groups">
        <label for="" class="box-input-label">{{ __('Details Message(Optional)') }}</label>
        <textarea name="message" class="form-textarea mb-0" placeholder="Details Message"></textarea>
    </div>

    <div class="action-btns">
        <button type="submit" name="approve" value="yes" class="site-btn-sm primary-btn me-2">
            <i icon-name="check"></i>
            {{ __('Approve') }}
        </button>
        <button type="submit" name="reject" value="yes" class="site-btn-sm red-btn">
            <i icon-name="x"></i>
            {{ __('Reject') }}
        </button>
    </div>

</form>

<script>
    'use strict';
    lucide.createIcons();
</script>






