<!DOCTYPE html>
<html>
<head>
    <title>Withdrawal OTP Verification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .container {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        .content {
            padding: 20px 0;
        }
        .otp-box {
            background-color: #f5f5f5;
            padding: 15px;
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 5px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .footer {
            padding-top: 20px;
            border-top: 1px solid #eee;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Withdrawal OTP Verification</h2>
        </div>
        
        <div class="content">
            <p>Hello {{ $full_name }},</p>
            
            <p>You have requested to withdraw funds from your account. To complete this transaction, please use the following One-Time Password (OTP):</p>
            
            <div class="otp-box">
                {{ $otp }}
            </div>
            
            <p>This OTP will expire in {{ $expires_in }}. If you did not request this withdrawal, please contact our support team immediately.</p>
            
            <p>Thank you for using our services.</p>
        </div>
        
        <div class="footer">
            <p>This is an automated message, please do not reply to this email.</p>
            <p>&copy; {{ $site_title }} - <a href="{{ $site_url }}">{{ $site_url }}</a></p>
        </div>
    </div>
</body>
</html>