@extends('frontend::layouts.user')

@section('title')
    {{ __('Achievement Dashboard') }}
@endsection

@section('content')
<div class="container-fluid default-page">
    <div class="row gy-30">
        <div class="col-xl-12">
            <!-- Achievement Hero Section -->
            <div class="rock-dashboard-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 20px; padding: 40px; margin-bottom: 30px;">
                <div class="text-center text-white">
                    <div class="mb-4">
                        <i class="anticon anticon-trophy" style="font-size: 48px; opacity: 0.9;"></i>
                    </div>
                    <h1 class="mb-3" style="font-size: 32px; font-weight: 700;">{{ __('Achievement Dashboard') }}</h1>
                    <p style="font-size: 18px; opacity: 0.9;">{{ __('Track your progress and unlock new ranks') }}</p>
                </div>
            </div>

            <!-- Current Rank Progress -->
            <div class="rock-dashboard-card" style="background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); backdrop-filter: blur(15px);">
                <div class="rock-dashboard-title-inner">
                    <h3 class="rock-dashboard-tile">{{ __('Current Rank Progress') }}</h3>
                </div>
                <div class="rock-dashboard-card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="rank-info-card text-center p-4" style="background: rgba(255, 255, 255, 0.08); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 15px; backdrop-filter: blur(10px);">
                                <h5 class="text-muted mb-2">{{ __('CURRENT RANK') }}</h5>
                                @if(isset($currentRankName) && $currentRankName)
                                    <span class="badge bg-primary fs-5 px-4 py-2">{{ $currentRankName }}</span>
                                @else
                                    <span class="badge bg-secondary fs-5 px-4 py-2">{{ __('No Rank') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="rank-info-card text-center p-4" style="background: rgba(255, 255, 255, 0.08); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 15px; backdrop-filter: blur(10px);">
                                <h5 class="text-muted mb-2">{{ __('NEXT TARGET') }}</h5>
                                @if(isset($nextRankName) && $nextRankName)
                                    <span class="badge bg-success fs-5 px-4 py-2">{{ $nextRankName }}</span>
                                @else
                                    <span class="badge bg-warning fs-5 px-4 py-2">{{ __('Max Rank Achieved') }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="progress-container mt-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">
                                @if(isset($currentRankName) && $currentRankName)
                                    {{ $currentRankName }}
                                @else
                                    {{ __('No Rank') }}
                                @endif
                            </span>
                            <span class="text-muted">
                                @if(isset($nextRankName) && $nextRankName)
                                    {{ $nextRankName }}
                                @else
                                    {{ __('Max Rank') }}
                                @endif
                            </span>
                        </div>
                        <div class="progress" style="height: 12px; background-color: rgba(255, 255, 255, 0.1); border-radius: 10px;">
                            <div class="progress-bar bg-success" role="progressbar" 
                                 style="width: {{ $progressPercentage ?? 0 }}%; border-radius: 10px;" 
                                 aria-valuenow="{{ $progressPercentage ?? 0 }}" 
                                 aria-valuemin="0" 
                                 aria-valuemax="100"></div>
                        </div>
                        <div class="text-center mt-2">
                            <span class="text-muted">
                                @if(isset($currentProgress) && isset($targetAmount) && $targetAmount > 0)
                                    ${{ number_format($currentProgress) }}/${{ number_format($targetAmount) }} USD ({{ $progressPercentage ?? 0 }}%)
                                @else
                                    {{ __('No progress data available') }}
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Referral Statistics -->
            <div class="rock-dashboard-card" style="margin-top: 30px;">
                <div class="rock-dashboard-title-inner">
                    <h3 class="rock-dashboard-tile">{{ __('Referral Statistics') }}</h3>
                    <p class="text-muted">{{ __('Your performance overview') }}</p>
                </div>
                <div class="rock-dashboard-card-body">
                    <div class="row g-4">
                        <div class="col-md-4">
                            <div class="stat-card text-center p-4" style="background: linear-gradient(135deg, rgba(78, 205, 196, 0.1) 0%, rgba(78, 205, 196, 0.05) 100%); border: 1px solid rgba(78, 205, 196, 0.2); border-radius: 15px; backdrop-filter: blur(10px);">
                                <div class="stat-icon mb-3" style="width: 60px; height: 60px; background: #4ecdc4; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="anticon anticon-usergroup-add text-white" style="font-size: 24px;"></i>
                                </div>
                                <div class="stat-number fs-3 fw-bold text-primary">{{ $totalReferrals ?? 0 }}</div>
                                <div class="stat-label text-muted">{{ __('Total Referrals') }}</div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="stat-card text-center p-4" style="background: linear-gradient(135deg, rgba(81, 207, 102, 0.1) 0%, rgba(81, 207, 102, 0.05) 100%); border: 1px solid rgba(81, 207, 102, 0.2); border-radius: 15px; backdrop-filter: blur(10px);">
                                <div class="stat-icon mb-3" style="width: 60px; height: 60px; background: #51cf66; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="anticon anticon-dollar text-white" style="font-size: 24px;"></i>
                                </div>
                                <div class="stat-number fs-3 fw-bold text-success">${{ $totalEarnings ?? 0 }}</div>
                                <div class="stat-label text-muted">{{ __('Total Earnings USD') }}</div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="stat-card text-center p-4" style="background: linear-gradient(135deg, rgba(255, 107, 107, 0.1) 0%, rgba(255, 107, 107, 0.05) 100%); border: 1px solid rgba(255, 107, 107, 0.2); border-radius: 15px; backdrop-filter: blur(10px);">
                                <div class="stat-icon mb-3" style="width: 60px; height: 60px; background: #ff6b6b; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="anticon anticon-target text-white" style="font-size: 24px;"></i>
                                </div>
                                <div class="stat-number fs-3 fw-bold text-danger">${{ $targetAmount ?? '3,600' }}</div>
                                <div class="stat-label text-muted">{{ __('Required Total USD') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Ranks -->
            <div class="rock-dashboard-card" style="background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); backdrop-filter: blur(15px);">
                <div class="rock-dashboard-title-inner">
                    <h3 class="rock-dashboard-tile">{{ __('Ranks') }}</h3>
                    <p class="text-muted">{{ __('Available ranks and requirements') }}</p>
                </div>
                <div class="rock-dashboard-card-body">
                    <div class="table-responsive">
                        <table class="table table-hover" style="background: rgba(255, 255, 255, 0.03); border-radius: 15px; overflow: hidden;">
                            <thead style="background: rgba(255, 255, 255, 0.08);">
                                <tr>
                                    <th style="border: none; color: rgba(255, 255, 255, 0.9);">{{ __('Rank') }}</th>
                                    <th style="border: none; color: rgba(255, 255, 255, 0.9);">{{ __('Team Volume (x4)') }}</th>
                                    <th style="border: none; color: rgba(255, 255, 255, 0.9);">{{ __('Total Volume') }}</th>
                                    <th style="border: none; color: rgba(255, 255, 255, 0.9);">{{ __('Reward') }}</th>
                                    <th style="border: none; color: rgba(255, 255, 255, 0.9);">{{ __('Salary') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="border: none;"><span class="badge bg-warning">🥇 {{ __('Leader') }}</span></td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$900 × 4</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$3,600</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$200</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$20</td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><span class="badge bg-info">🥈 {{ __('Senior Team Leader') }}</span></td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$3,600 × 4</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$14,400</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$400</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$40</td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><span class="badge bg-success">🥉 {{ __('Sales Manager') }}</span></td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$14,400 × 4</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$57,600</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$1,600</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$80</td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><span class="badge bg-primary">🏅 {{ __('Senior Sales Manager') }}</span></td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$57,600 × 4</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$230,400</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$6,400</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$160</td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><span class="badge bg-warning">🎖 {{ __('Director') }}</span></td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$230,400 × 4</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$921,600</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$25,600</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$320</td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><span class="badge bg-secondary">🌍 {{ __('Global Ambassador') }}</span></td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$921,600 × 4</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$3,686,400</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$102,400</td>
                                    <td style="border: none; color: rgba(255, 255, 255, 0.9);" class="fw-bold">$1,000</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Referral Users Progress -->
            <div class="rock-dashboard-card" style="background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); backdrop-filter: blur(15px);">
                <div class="rock-dashboard-title-inner">
                    <h3 class="rock-dashboard-tile">{{ __('Referral Users Progress') }}</h3>
                    <p class="text-muted">{{ __('Track individual referral achievements') }}</p>
                </div>
                <div class="rock-dashboard-card-body">
                    @if(isset($referralUsers) && count($referralUsers) > 0)
                        <div class="row g-4">
                            @foreach($referralUsers as $referralUser)
                            <div class="col-md-6 col-lg-4 mb-4">
                                <div class="referral-user-card p-4" style="background: rgba(255, 255, 255, 0.08); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 15px; backdrop-filter: blur(10px);">
                                    <div class="user-info d-flex align-items-center mb-3">
                                        <div class="user-avatar me-3" style="width: 50px; height: 50px; background: #4ecdc4; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                            <i class="anticon anticon-user text-white"></i>
                                        </div>
                                        <div class="user-details">
                                            <div class="user-name fw-bold text-white">{{ $referralUser->username ?? 'Unknown' }}</div>
                                            <div class="user-email text-muted small">{{ $referralUser->email ?? 'No email' }}</div>
                                        </div>
                                    </div>
                                    <div class="user-progress">
                                        <div class="progress-item d-flex justify-content-between mb-2">
                                            <span class="label text-muted">{{ __('Balance') }}</span>
                                            <span class="value fw-bold text-white">${{ $referralUser->total_deposit ?? 0 }}</span>
                                        </div>
                                        <div class="progress-item d-flex justify-content-between mb-2">
                                            <span class="label text-muted">{{ __('Investment') }}</span>
                                            <span class="value fw-bold text-white">${{ $referralUser->total_invest ?? 0 }}</span>
                                        </div>
                                        <div class="progress-item d-flex justify-content-between mb-2">
                                            <span class="label text-muted">{{ __('Profit') }}</span>
                                            <span class="value fw-bold text-white">${{ $referralUser->total_profit ?? 0 }}</span>
                                        </div>
                                        <div class="progress-item d-flex justify-content-between">
                                            <span class="label text-muted">{{ __('Join Date') }}</span>
                                            <span class="value fw-bold text-white">{{ $referralUser->join_date ? \Carbon\Carbon::parse($referralUser->join_date)->format('M d, Y') : 'N/A' }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="mb-3">
                                <i class="anticon anticon-usergroup-add" style="font-size: 64px; color: rgba(255, 255, 255, 0.3);"></i>
                            </div>
                            <h5 class="text-muted">{{ __('No Referral Users Found') }}</h5>
                            <p class="text-muted">{{ __('Start referring users to see their progress here') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
