@extends('frontend::layouts.user')
@section('title')
    {{ __('All Plans') }}
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">{{ __('All The Plans') }}</h3>
                </div>
                <div class="site-card-body">
                    <div class="row">
                        @foreach($schemas as $schema)

                            <div class="col-xxl-3 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                <div class="single-investment-plan">
                                    <img
                                        class="investment-plan-icon"
                                        src="{{ asset($schema->icon) }}"
                                        alt=""
                                    />
                                    @if($schema->badge)
                                        <div class="feature-plan">{{$schema->badge}}</div>
                                    @endif

                                    <h3>{{$schema->name}}</h3>
                                    <p>{{$schema->schedule->name . ' '. ($schema->interest_type == 'percentage' ? $schema->return_interest.'%' : $currencySymbol.$schema->return_interest ) }}</p>
                                    <ul>
                                        <li>{{ __('Investment') }} <span class="special">
                                            {{ $schema->type == 'range' ? $currencySymbol . $schema->min_amount . '-' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount }}
                                        </span></li>
                                        <li>{{ __('Capital Back') }}
                                            <span>{{ $schema->capital_back ? 'Yes' : 'No' }}</span></li>
                                        <li>{{ __('Return Type') }} <span>{{ ucwords($schema->return_type) }}</span>
                                        </li>
                                        <li>{{ __('Number of Period') }}
                                            <span>{{ ($schema->return_type == 'period' ? $schema->number_of_period : 'Unlimited').($schema->number_of_period == 1 ? ' Time' : ' Times' )  }}</span>
                                        </li>
                                        <li>{{ __('Profit Withdraw') }} <span>{{ __('Anytime') }}</span></li>
                                        <li>{{ __('Cancel') }} <span> @if($schema->schema_cancel)
                                                    {{ __('Within').' '. $schema->expiry_minute .' '. 'Minute' }}
                                                @else
                                                    {{ __('No') }}
                                                @endif</span></li>
                                        @if($schema->schema_duration)
                                        <li>{{ __('Plan Duration') }} <span>{{ $schema->schema_duration }} {{ __('Days') }}</span></li>
                                        @endif
                                        @if($schema->schema_cancel)
                                        <li>{{ __('Money Back Period') }} <span>{{ $schema->money_back_period ?? 15 }} {{ __('Days') }}</span></li>
                                        <li>{{ __('Early Withdrawal Fee') }} <span>{{ $schema->early_withdrawal_deduction ?? 25 }}%</span></li>
                                        @endif
                                    </ul>
                                    <div class="holidays" style="color: black;"><span class="star">*</span>@if( null != $schema->off_days)
                                            {{ implode(', ', json_decode($schema->off_days,true))  .' '.__('are')}}
                                        @else
                                            {{ __('No Profit') }}
                                        @endif {{ __('Holidays') }}
                                        @if( null != $schema->off_days && in_array('Saturday', json_decode($schema->off_days,true)) && in_array('Sunday', json_decode($schema->off_days,true)))
                                            <br><small style="color: black; font-style: italic; font-weight: 500;">{{ __('We work in Stock Exchange & Forex Market') }}</small>
                                        @endif
                                    </div>
                                    
                                    @if($schema->schema_cancel)
                                    <div class="return-policy mt-3 p-3" style="background: rgba(74, 144, 226, 0.1); border-radius: 8px; border-left: 4px solid #4a90e2;">
                                        <h6 class="mb-2" style="color: #4a90e2; font-weight: 600;">
                                            <i class="fas fa-shield-alt"></i> {{ __('Flexible Return Policy') }}
                                        </h6>
                                        <div class="policy-details" style="font-size: 12px; color: #666;">
                                            <div class="mb-1">
                                                <strong>{{ __('Grace Period:') }}</strong> {{ __('Cancel within') }} {{ $schema->expiry_minute }} {{ __('minutes without penalty') }}
                                            </div>
                                            <div class="mb-1">
                                                <strong>{{ __('Money Back:') }}</strong> {{ __('Full refund within') }} {{ $schema->money_back_period ?? 15 }} {{ __('days') }}
                                            </div>
                                            <div class="mb-1">
                                                <strong>{{ __('Early Withdrawal:') }}</strong> {{ __('Same deduction applies') }}
                                            </div>
                                            <div style="color: #28a745; font-weight: 500;">
                                                <i class="fas fa-check-circle"></i> {{ __('Your investment is protected!') }}
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    
                                    <a href="{{route('user.schema.preview',$schema->id)}}"
                                       class="site-btn grad-btn w-100 centered mt-3"><i
                                            class="anticon anticon-check"></i>{{ __('Invest Now') }}</a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
