@extends('frontend::layouts.user')
@section('title')
    {{ __('Dashboard') }}
@endsection
@section('content')

    <div class="desktop-screen-show">
        {{--Referral and Ranking --}}
        @include('frontend::user.include.__referral_ranking')

        {{-- User Card--}}
        @include('frontend::user.include.__user_card')

        {{-- TradingView Chart Section --}}
        <div class="row mt-4">
            <div class="col-12">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('LIVE STOCK & FOREX MARKET') }}</h3>
                    </div>
                    <div class="site-card-body">
                        <!-- TradingView Ticker Tape Widget BEGIN -->
                        <div class="tradingview-widget-container mb-4">
                            <div class="tradingview-widget-container__widget"></div>
                            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                            {
                                "symbols": [
                                    {"proName": "BINANCE:BTCUSDT", "title": "Bitcoin"},
                                    {"proName": "BINANCE:ETHUSDT", "title": "Ethereum"},
                                    {"proName": "BINANCE:BNBUSDT", "title": "BNB"},
                                    {"proName": "BINANCE:XRPUSDT", "title": "XRP"},
                                    {"proName": "FX_IDC:EURUSD", "title": "EUR/USD"},
                                    {"proName": "FX_IDC:GBPUSD", "title": "GBP/USD"},
                                    {"proName": "NASDAQ:AAPL", "title": "Apple"},
                                    {"proName": "NASDAQ:TSLA", "title": "Tesla"},
                                    {"proName": "TVC:GOLD", "title": "Gold"},
                                    {"proName": "CRYPTOCAP:TOTAL", "title": "Crypto Market Cap"}
                                ],
                                "showSymbolLogo": true,
                                "colorTheme": "light",
                                "isTransparent": false,
                                "displayMode": "adaptive",
                                "locale": "en"
                            }
                            </script>
                        </div>
                        <!-- TradingView Ticker Tape Widget END -->

                        <!-- TradingView Advanced Chart Widget BEGIN -->
                        <div class="tradingview-widget-container" style="height: 500px;">
                            <div id="tradingview_chart_dashboard"></div>
                            <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                            <script type="text/javascript">
                                new TradingView.widget({
                                    "width": "100%",
                                    "height": 480,
                                    "symbol": "BINANCE:BTCUSDT",
                                    "interval": "15",
                                    "timezone": "Etc/UTC",
                                    "theme": "light",
                                    "style": "1",
                                    "locale": "en",
                                    "toolbar_bg": "#f1f3f6",
                                    "enable_publishing": false,
                                    "allow_symbol_change": true,
                                    "save_image": false,
                                    "container_id": "tradingview_chart_dashboard"
                                });
                            </script>
                        </div>
                        <!-- TradingView Advanced Chart Widget END -->
                    </div>
                </div>
            </div>
        </div>

        {{--Recent Transactions--}}
        @include('frontend::user.include.__recent_transaction')
    </div>

    {{--for mobile--}}
    <div class="mobile-screen-show">
        @include('frontend::user.mobile_screen_include.dashboard.__index')
    </div>

@endsection
@section('script')
    <script>
        function copyRef() {
            /* Get the text field */
            var textToCopy = $('#refLink').val();
            // Create a temporary input element
            var tempInput = $('<input>');
            $('body').append(tempInput);
            tempInput.val(textToCopy).select();
            // Copy the text from the temporary input
            document.execCommand('copy');
            // Remove the temporary input element
            tempInput.remove();
            $('#copy').text('Copied');
            var copyApi = document.getElementById("refLink");
            /* Select the text field */
            copyApi.select();
            copyApi.setSelectionRange(0, 999999999); /* For mobile devices */
            /* Copy the text inside the text field */
            document.execCommand('copy');
            $('#copy').text('Copied')

        }

        // Load More
        $('.moreless-button').click(function () {
            $('.moretext').slideToggle();
            if ($('.moreless-button').text() == "Load more") {
                $(this).text("Load less")
            } else {
                $(this).text("Load more")
            }
        });

        $('.moreless-button-2').click(function () {
            $('.moretext-2').slideToggle();
            if ($('.moreless-button-2').text() == "Load more") {
                $(this).text("Load less")
            } else {
                $(this).text("Load more")
            }
        });
    </script>
@endsection
