@extends('frontend::layouts.user')
@section('title')
    {{ __('Withdrawal Success') }}
@endsection
@section('content')
<div class="row justify-content-center">
    <div class="col-xl-8 col-lg-10">
        <div class="site-card" style="background: rgba(255,255,255,0.1); backdrop-filter: blur(10px); border-radius: 15px; border: 1px solid rgba(255,255,255,0.2);">
            <div class="site-card-body text-center py-5">
                <div class="mb-4">
                    <div class="success-icon" style="font-size: 4rem; color: #28a745;">
                        ✅
                    </div>
                </div>
                
                <h2 class="text-success mb-3">{{ __('Withdrawal Request Submitted!') }}</h2>
                
                <div class="alert alert-success" style="background: rgba(40, 167, 69, 0.1); border: 1px solid rgba(40, 167, 69, 0.3);">
                    <h5>🎉 {{ __('Success!') }}</h5>
                    <p class="mb-0">{{ __('Your withdrawal request has been submitted successfully and is now under review.') }}</p>
                </div>
                
                <div class="alert alert-info" style="background: rgba(23, 162, 184, 0.1); border: 1px solid rgba(23, 162, 184, 0.3);">
                    <h6>⏰ {{ __('Processing Time') }}</h6>
                    <p class="mb-0">{{ __('Your withdrawal will be processed within 24 hours during business days.') }}</p>
                </div>
                
                <div class="alert alert-warning" style="background: rgba(255, 193, 7, 0.1); border: 1px solid rgba(255, 193, 7, 0.3);">
                    <h6>📧 {{ __('Email Notification') }}</h6>
                    <p class="mb-0">{{ __('You will receive an email notification once your withdrawal is processed.') }}</p>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('user.withdraw.simple.index') }}" class="btn btn-primary w-100">
                            {{ __('Make Another Withdrawal') }}
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('user.withdraw.log') }}" class="btn btn-secondary w-100">
                            {{ __('View Withdrawal History') }}
                        </a>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-12">
                        <a href="{{ route('user.dashboard') }}" class="btn btn-outline-primary w-100">
                            {{ __('Back to Dashboard') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection