@if(auth()->check())
<div id="announcement-popup-container" style="display: none;">
    <div class="announcement-popup-overlay" id="announcement-overlay">
        <div class="announcement-popup" id="announcement-popup">
            <div class="announcement-popup-header">
                <div class="announcement-type-badge" id="announcement-type-badge"></div>
                <button type="button" class="announcement-close-btn" onclick="closeAnnouncementPopup()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="announcement-popup-body">
                <h4 id="announcement-title"></h4>
                <div id="announcement-message"></div>
            </div>
            <div class="announcement-popup-footer">
                <button type="button" class="btn btn-primary" onclick="closeAnnouncementPopup()">
                    Got it!
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.announcement-popup-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
    animation: fadeIn 0.3s ease-in-out;
}

.announcement-popup {
    background: white;
    border-radius: 12px;
    max-width: 500px;
    width: 90%;
    max-height: 80vh;
    overflow-y: auto;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
    animation: slideIn 0.3s ease-out;
}

.announcement-popup-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px 20px 0 20px;
    border-bottom: 1px solid #eee;
    margin-bottom: 15px;
}

.announcement-type-badge {
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.announcement-type-badge.announcement {
    background: #e3f2fd;
    color: #1976d2;
}

.announcement-type-badge.offer {
    background: #e8f5e8;
    color: #2e7d32;
}

.announcement-type-badge.promotion {
    background: #fff3e0;
    color: #f57c00;
}

.announcement-close-btn {
    background: none;
    border: none;
    font-size: 18px;
    color: #666;
    cursor: pointer;
    padding: 5px;
    border-radius: 50%;
    transition: all 0.2s;
}

.announcement-close-btn:hover {
    background: #f5f5f5;
    color: #333;
}

.announcement-popup-body {
    padding: 0 20px 20px 20px;
}

.announcement-popup-body h4 {
    margin-bottom: 15px;
    color: #333;
    font-weight: 600;
}

.announcement-popup-body div {
    line-height: 1.6;
    color: #666;
}

.announcement-popup-footer {
    padding: 15px 20px 20px 20px;
    border-top: 1px solid #eee;
    text-align: right;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideIn {
    from { 
        opacity: 0;
        transform: translateY(-50px) scale(0.9);
    }
    to { 
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

@media (max-width: 768px) {
    .announcement-popup {
        width: 95%;
        margin: 20px;
    }
}
</style>

<script>
let currentAnnouncementIndex = 0;
let announcements = [];

// Load announcements on page load
document.addEventListener('DOMContentLoaded', function() {
    loadAnnouncements();
});

function loadAnnouncements() {
    fetch('{{ route("announcement.popup") }}')
        .then(response => response.json())
        .then(data => {
            if (data.success && data.announcements.length > 0) {
                announcements = data.announcements;
                showNextAnnouncement();
            }
        })
        .catch(error => {
            console.error('Error loading announcements:', error);
        });
}

function showNextAnnouncement() {
    if (currentAnnouncementIndex >= announcements.length) {
        return; // All announcements shown
    }

    const announcement = announcements[currentAnnouncementIndex];
    
    // Set announcement content
    document.getElementById('announcement-title').textContent = announcement.title;
    document.getElementById('announcement-message').innerHTML = announcement.message;
    
    // Set type badge
    const badge = document.getElementById('announcement-type-badge');
    badge.textContent = announcement.type.charAt(0).toUpperCase() + announcement.type.slice(1);
    badge.className = 'announcement-type-badge ' + announcement.type;
    
    // Show popup
    document.getElementById('announcement-popup-container').style.display = 'block';
    document.body.style.overflow = 'hidden'; // Prevent background scrolling
}

function closeAnnouncementPopup() {
    document.getElementById('announcement-popup-container').style.display = 'none';
    document.body.style.overflow = ''; // Restore scrolling
    
    // Show next announcement after a short delay
    currentAnnouncementIndex++;
    setTimeout(() => {
        if (currentAnnouncementIndex < announcements.length) {
            showNextAnnouncement();
        }
    }, 500);
}

// Close popup when clicking overlay
document.addEventListener('click', function(e) {
    if (e.target.id === 'announcement-overlay') {
        closeAnnouncementPopup();
    }
});

// Close popup with Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape' && document.getElementById('announcement-popup-container').style.display === 'block') {
        closeAnnouncementPopup();
    }
});
</script>
@endif

